package cn.com.poc.timbre.model;	

import java.io.Serializable;
import cn.com.yict.framemax.data.model.BaseModelClass;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Id;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Version;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;

/**
 * Model class for biz_voice_timbre
 * 音频音色表
 */
@Entity
@Table(name = "biz_voice_timbre")
@DynamicInsert
@DynamicUpdate
public class BizVoiceTimbreModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;
    
  
    /** id
    *主键
    */ 
    private java.lang.Integer id;
    
    @Column(name = "id",length = 10)
	@Id @GeneratedValue(strategy = GenerationType.AUTO) 
    public java.lang.Integer getId(){
        return this.id;
    }
    
    public void setId(java.lang.Integer id){
        this.id = id;
        super.addValidField("id");
    }
    
  
    /** timbre_id
    *音色ID
    */ 
    private java.lang.String timbreId;
    
    @Column(name = "timbre_id",length = 100)
    public java.lang.String getTimbreId(){
        return this.timbreId;
    }
    
    public void setTimbreId(java.lang.String timbreId){
        this.timbreId = timbreId;
        super.addValidField("timbreId");
    }
    
  
    /** language
    *音色语言分类  0-中文 1-粤语 2-英文
    */ 
    private java.lang.Integer language;
    
    @Column(name = "language",length = 10)
    public java.lang.Integer getLanguage(){
        return this.language;
    }
    
    public void setLanguage(java.lang.Integer language){
        this.language = language;
        super.addValidField("language");
    }
    
  
    /** timbre_name
    *音色名-简体中文
    */ 
    private java.lang.String timbreName;
    
    @Column(name = "timbre_name",length = 100)
    public java.lang.String getTimbreName(){
        return this.timbreName;
    }
    
    public void setTimbreName(java.lang.String timbreName){
        this.timbreName = timbreName;
        super.addValidField("timbreName");
    }
    
  
    /** timbre_name_en
    *音色名-英文
    */ 
    private java.lang.String timbreNameEn;
    
    @Column(name = "timbre_name_en",length = 100)
    public java.lang.String getTimbreNameEn(){
        return this.timbreNameEn;
    }
    
    public void setTimbreNameEn(java.lang.String timbreNameEn){
        this.timbreNameEn = timbreNameEn;
        super.addValidField("timbreNameEn");
    }
    
  
    /** timbre_name_tw
    *音色名-繁体
    */ 
    private java.lang.String timbreNameTw;
    
    @Column(name = "timbre_name_tw",length = 100)
    public java.lang.String getTimbreNameTw(){
        return this.timbreNameTw;
    }
    
    public void setTimbreNameTw(java.lang.String timbreNameTw){
        this.timbreNameTw = timbreNameTw;
        super.addValidField("timbreNameTw");
    }
    
  
    /** voice_url
    *音色预览地址
    */ 
    private java.lang.String voiceUrl;
    
    @Column(name = "voice_url",length = 120)
    public java.lang.String getVoiceUrl(){
        return this.voiceUrl;
    }
    
    public void setVoiceUrl(java.lang.String voiceUrl){
        this.voiceUrl = voiceUrl;
        super.addValidField("voiceUrl");
    }
    
  
    /** is_deleted
    *是否删除 Y 是  N 否
    */ 
    private java.lang.String isDeleted;
    
    @Column(name = "is_deleted",length = 1)
    public java.lang.String getIsDeleted(){
        return this.isDeleted;
    }
    
    public void setIsDeleted(java.lang.String isDeleted){
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }
    
  
    /** CREATOR
    *创建人
    */ 
    private java.lang.String creator;
    
    @Column(name = "CREATOR",length = 50)
    public java.lang.String getCreator(){
        return this.creator;
    }
    
    public void setCreator(java.lang.String creator){
        this.creator = creator;
        super.addValidField("creator");
    }
    
  
    /** CREATED_TIME
    *创建时间
    */ 
    private java.util.Date createdTime;
    
    @Column(name = "CREATED_TIME",length = 19)
    public java.util.Date getCreatedTime(){
        return this.createdTime;
    }
    
    public void setCreatedTime(java.util.Date createdTime){
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }
    
  
    /** MODIFIER
    *修改人
    */ 
    private java.lang.String modifier;
    
    @Column(name = "MODIFIER",length = 50)
    public java.lang.String getModifier(){
        return this.modifier;
    }
    
    public void setModifier(java.lang.String modifier){
        this.modifier = modifier;
        super.addValidField("modifier");
    }
    
  
    /** MODIFIED_TIME
    *修改时间
    */ 
    private java.util.Date modifiedTime;
    
    @Column(name = "MODIFIED_TIME",length = 19)
    public java.util.Date getModifiedTime(){
        return this.modifiedTime;
    }
    
    public void setModifiedTime(java.util.Date modifiedTime){
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }
    
  
    /** SYS_VERSION
    *乐观锁,版本号
    */ 
    private java.lang.Integer sysVersion;
    
    @Column(name = "SYS_VERSION",length = 10)
	@Version
    public java.lang.Integer getSysVersion(){
        return this.sysVersion;
    }
    
    public void setSysVersion(java.lang.Integer sysVersion){
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }
    

}