package cn.com.poc.timbre.service.impl;

import cn.com.poc.common.constant.CommonConstant;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.timbre.service.BizVoiceTimbreService;
import cn.com.poc.timbre.model.BizVoiceTimbreModel;
import cn.com.poc.timbre.entity.BizVoiceTimbreEntity;
import cn.com.poc.timbre.convert.BizVoiceTimbreConvert;
import cn.com.poc.timbre.repository.BizVoiceTimbreRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizVoiceTimbreServiceImpl extends BaseServiceImpl
        implements BizVoiceTimbreService {

    @Resource
    private BizVoiceTimbreRepository repository;

    @Override
    public BizVoiceTimbreEntity getByTimbreId(String timbreId)  {
        BizVoiceTimbreModel bizVoiceTimbreModel = new BizVoiceTimbreModel();
        bizVoiceTimbreModel.setTimbreId(timbreId);
        bizVoiceTimbreModel.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizVoiceTimbreModel> models = this.repository.findByExample(bizVoiceTimbreModel);
        if (CollectionUtils.isNotEmpty(models)) {
            return BizVoiceTimbreConvert.modelToEntity(models.get(0));
        }
        return null;
    }

    @Override
    public List<BizVoiceTimbreEntity> findByExample(BizVoiceTimbreEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizVoiceTimbreEntity> result = new ArrayList<BizVoiceTimbreEntity>();
        BizVoiceTimbreModel model = new BizVoiceTimbreModel();
        if (example != null) {
            model = BizVoiceTimbreConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizVoiceTimbreModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizVoiceTimbreConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }
}