package cn.com.poc.travel_business.rest.impl;

import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.poc.travel_business.aggregate.TravelBusinessService;
import cn.com.poc.travel_business.dto.TravelBusinessDialoguesDto;
import cn.com.poc.travel_business.rest.TravelBusinessRest;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author alex.yao
 * @date 2025/6/27
 */
@Component
public class TravelBusinessRestImpl implements TravelBusinessRest {
    @Resource
    private TravelBusinessService travelBusinessService;

    @Override
    public void call(TravelBusinessDialoguesDto travelBusinessDialoguesDto) throws Exception {
        Assert.notNull(travelBusinessDialoguesDto, "对话信息不能为空");
        Assert.notNull(travelBusinessDialoguesDto.getDialoguesId(), "对话id不能为空");
        Assert.notNull(travelBusinessDialoguesDto.getInput(), "问题不能为空");

        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new RuntimeException("用户未登录");
        }
        travelBusinessService.call(
                travelBusinessDialoguesDto.getDialoguesId(),
                travelBusinessDialoguesDto.getInput(),
                travelBusinessDialoguesDto.getFileUrl(),
                travelBusinessDialoguesDto.getKnowledgeIds(),
                null,
                userBaseEntity.getUserId()
        );
    }
}
