package cn.com.poc.user.aggregation.impl;

import cn.com.poc.common.constant.RedisKeyConstant;
import cn.com.poc.common.service.RedisService;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.user.dto.MemberPasswordRequestDto;
import cn.com.poc.user.aggregation.MemberInfoService;
import cn.com.poc.user.constants.Member3rdPartyRelationConstants;
import cn.com.poc.user.entity.Member3rdPartyRelationEntity;
import cn.com.poc.user.entity.MemberInfoEntity;
import cn.com.poc.user.query.CheckMemberInfoQueryCondition;
import cn.com.poc.user.query.CheckMemberInfoQueryItem;
import cn.com.poc.user.service.BizMember3rdPartyRelationService;
import cn.com.poc.user.service.BizMemberInfoService;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Author：Roger Wu
 * @name：aggregation
 * @Date：2024-07-26 9:40
 */

@Component
public class MemberInfoServiceImpl extends BaseServiceImpl implements MemberInfoService {
    @Resource
    private BizMemberInfoService bizMemberInfoService;
    @Resource
    private BizMember3rdPartyRelationService bizMember3rdPartyRelationService;

    @Resource
    private RedisService redisService;

    /**
     * @param memberPasswordRequestDto
     */
    @Override
    public void configureMemberPassword(MemberPasswordRequestDto memberPasswordRequestDto) throws Exception {

        MemberInfoEntity memberInfoEntity = bizMemberInfoService.getMemberEntityByAccount(memberPasswordRequestDto.getAccount());
        if (memberInfoEntity == null) {
            throw new I18nMessageException("exception/user.cannot.be.found");
        }

        String authCode = (String) redisService.get(RedisKeyConstant.Code.AUTH_CODE + memberPasswordRequestDto.getAccount());
        if (StringUtils.isBlank(authCode) && StringUtils.isNotBlank(memberInfoEntity.getMobilePhone())) {
            authCode = (String) redisService.get(RedisKeyConstant.Code.AUTH_CODE + memberInfoEntity.getMobilePhone());
        }
        if (StringUtils.isBlank(authCode) && StringUtils.isNotBlank(memberInfoEntity.getEmail())) {
            authCode = (String) redisService.get(RedisKeyConstant.Code.AUTH_CODE + memberInfoEntity.getEmail());
        }

        if (!memberPasswordRequestDto.getAuthCode().equals(authCode)) {
            throw new I18nMessageException("exception/re-verify.the.user.identity");
        }

        Member3rdPartyRelationEntity member3rdPartyRelationEntity = bizMember3rdPartyRelationService.getPwRelationByMemberId(memberInfoEntity.getMemberId());
        if (member3rdPartyRelationEntity == null) {
            member3rdPartyRelationEntity = new Member3rdPartyRelationEntity();
            member3rdPartyRelationEntity.setRelationPlatform(Member3rdPartyRelationConstants.RelationType.PW);
            member3rdPartyRelationEntity.setMemberId(memberInfoEntity.getMemberId());
        }
        member3rdPartyRelationEntity.setRelationKey(memberPasswordRequestDto.getPassword());
        bizMember3rdPartyRelationService.createOrUpdateRelation(member3rdPartyRelationEntity);

        redisService.del(RedisKeyConstant.Code.AUTH_CODE + memberPasswordRequestDto.getAccount());
    }

    @Override
    public MemberInfoEntity updateMemberInfo(MemberInfoEntity memberInfoEntity) {
        if (StringUtils.isNotBlank(memberInfoEntity.getMobilePhone())) {
            CheckMemberInfoQueryCondition condition = new CheckMemberInfoQueryCondition();
            condition.setMemberId(memberInfoEntity.getMemberId().longValue());
            condition.setMobilePhone(memberInfoEntity.getMobilePhone());
            List<CheckMemberInfoQueryItem> checkMemberInfoQueryItems = bizMemberInfoService.checkMemberInfoIsExist(condition);
            if (CollectionUtils.isNotEmpty(checkMemberInfoQueryItems)) {
                throw new I18nMessageException("exception/phone.is.exist");
            }
        }
        if (StringUtils.isNotBlank(memberInfoEntity.getEmail())) {
            CheckMemberInfoQueryCondition condition = new CheckMemberInfoQueryCondition();
            condition.setMemberId(memberInfoEntity.getMemberId().longValue());
            condition.setEmail(memberInfoEntity.getEmail());
            List<CheckMemberInfoQueryItem> checkMemberInfoQueryItems = bizMemberInfoService.checkMemberInfoIsExist(condition);
            if (CollectionUtils.isNotEmpty(checkMemberInfoQueryItems)) {
                throw new I18nMessageException("exception/email.is.exist");
            }
        }
        return bizMemberInfoService.updateMemberInfo(memberInfoEntity);
    }
}
