package cn.com.poc.writing.aggregate;

import cn.com.poc.writing.dto.AiWritingDialoguesContextDto;
import cn.com.poc.writing.dto.AiWritingExampleDto;
import cn.com.poc.writing.dto.AiWritingExampleTypeDto;
import cn.com.poc.writing.dto.AiWritingTitleGenerationDto;

import java.util.List;

/**
 * @author alex.yao
 * @date 2025/6/20
 */
public interface AiWritingService {


    /**
     * 调用AI写作
     *
     * @param dialoguesId
     * @param fileUrl
     * @param input
     * @param knowledgeIds
     * @param userId
     * @param enableSearchEngine
     * @param enableDeepThinking
     */
    void call(String dialoguesId, String fileUrl, String input, Integer[] knowledgeIds, Long userId, Boolean enableSearchEngine, Boolean enableDeepThinking) throws Exception;


    /**
     * 获取示例列表
     *
     * @param type 类型
     * @return
     */
    List<AiWritingExampleDto> example(String type) throws Exception;

    /**
     * 获取示例类型
     *
     * @return
     */
    List<AiWritingExampleTypeDto> exampleType() throws Exception;

    /**
     * 标题生成
     *
     * @param input 输入内容g
     */
    AiWritingTitleGenerationDto titleGeneration(String input);


    /**
     * 获取对话上下文
     *
     * @param dialogueId
     * @return
     */
    List<AiWritingDialoguesContextDto> getDialogueContext(String dialogueId);


}
