package cn.com.poc.writing.aggregate;

import cn.com.poc.writing.entity.ExaminationConfigItemEntity;
import cn.com.poc.writing.entity.ExaminationEntity;
import cn.com.poc.writing.entity.GenerateExaminationEntity;

import java.util.List;

/**
 * 智能出题服务
 *
 * @author 52747
 * @date 2025/8/14
 */
public interface ExaminationService {

    /**
     * 获取试卷生成配置项
     * 出题类型
     * 难度等级
     * 出题语言
     * 适用岗位
     */
    ExaminationConfigItemEntity getConfigurationItem();

    /**
     * 生成试卷
     * sse 输出
     */
    void generateExamination(GenerateExaminationEntity generateExaminationEntity, Long userId);

    /**
     * 获取生成试卷信息
     *
     * @param examinationId 查询
     * @param userId        用户ID
     */
    ExaminationEntity getExaminations(String examinationId, Long userId);

    /**
     * 获取历史记录
     *
     * @param query  查询
     * @param userId 用户ID
     */
    List<ExaminationEntity> getList(String query, Long userId);

    /**
     * 批量删除
     *
     * @param examinationIds 试卷ID
     * @param userId         用户ID
     */
    boolean batchDelete(List<String> examinationIds, Long userId);


    /**
     * 试卷文件下载
     *
     * @param examinationId 试卷id
     * @param userId        用户id
     * @return 下载地址
     */
    String downloadExamination(String examinationId, Long userId);
}
