package cn.com.poc.writing.rest;

import cn.com.poc.writing.dto.*;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 智能出题接口
 *
 * @author 52747
 * @date 2025/8/14
 */
@Permission(Access.Safety)
public interface ExaminationRest extends BaseRest {


    /**
     * 获取试卷生成配置项
     * 出题类型
     * 难度等级
     * 出题语言
     * 适用岗位
     */
    ExaminationConfigItemDto getConfigurationItem();

    /**
     * 生成试卷
     * sse 输出
     *
     * @param generateExaminationDto 出题配置
     */
    void generateExamination(@RequestBody GenerateExaminationDto generateExaminationDto);

    /**
     * 获取试卷
     *
     * @param examinationId 试卷ID
     */
    ExaminationDto getExaminations(@RequestParam(value = "examinationId") String examinationId);

    /**
     * 获取历史记录
     *
     * @param query 查询
     * @return
     */
    List<ExaminationDto> getList(@RequestParam(value = "query", required = false) String query);


    /**
     * 批量删除
     *
     * @param dto
     */
    void batchDelete(@RequestBody ExaminationBatchDeleteDto dto);

    /**
     * 试卷文件下载
     *
     * @param examinationId 试卷ID
     */
    String downloadExamination(@RequestParam(value = "examinationId") String examinationId);

}
