package cn.com.poc.writing.rest.impl;	

import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import cn.com.poc.writing.rest.BizAiWritingDialoguesRecordRest;
import cn.com.poc.writing.service.BizAiWritingDialoguesRecordService;
import cn.com.poc.writing.dto.BizAiWritingDialoguesRecordDto;
import cn.com.poc.writing.entity.BizAiWritingDialoguesRecordEntity;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.poc.writing.convert.BizAiWritingDialoguesRecordConvert;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

@Component
public class BizAiWritingDialoguesRecordRestImpl implements BizAiWritingDialoguesRecordRest {
   
   	@Resource
    private BizAiWritingDialoguesRecordService service;
    			 
	public BizAiWritingDialoguesRecordDto getById(java.lang.Long id) throws Exception{
		Assert.notNull(id);
 		return BizAiWritingDialoguesRecordConvert.entityToDto(service.get(id));
   	}
    
   	public List<BizAiWritingDialoguesRecordDto> getList(BizAiWritingDialoguesRecordDto dto,PagingInfo pagingInfo) throws Exception{
       	return service
		        .findByExample(BizAiWritingDialoguesRecordConvert.dtoToEntity(dto),pagingInfo)
		        .stream()
				.map(BizAiWritingDialoguesRecordConvert::entityToDto)
				.collect(Collectors.toList());
   	}

   	public BizAiWritingDialoguesRecordDto save(BizAiWritingDialoguesRecordDto dto) throws Exception{
		Assert.notNull(dto);
		BizAiWritingDialoguesRecordEntity entity = BizAiWritingDialoguesRecordConvert.dtoToEntity(dto);
       	return BizAiWritingDialoguesRecordConvert.entityToDto(service.save(entity));
   	}
    
	
    public BizAiWritingDialoguesRecordDto update(BizAiWritingDialoguesRecordDto dto) throws Exception{
		Assert.notNull(dto);
		BizAiWritingDialoguesRecordEntity entity = BizAiWritingDialoguesRecordConvert.dtoToEntity(dto);
       	return BizAiWritingDialoguesRecordConvert.entityToDto(service.update(entity));
	}

    public void deletedById(java.lang.Long id) throws Exception{
		Assert.notNull(id);
		service.deletedById(id);
	}
}