package cn.com.poc.writing.service.impl;

import cn.com.poc.writing.query.AiWritingDialoguesRecordQueryCondition;
import cn.com.poc.writing.query.AiWritingDialoguesRecordQueryItem;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.writing.service.BizAiWritingDialoguesRecordService;
import cn.com.poc.writing.model.BizAiWritingDialoguesRecordModel;
import cn.com.poc.writing.entity.BizAiWritingDialoguesRecordEntity;
import cn.com.poc.writing.convert.BizAiWritingDialoguesRecordConvert;
import cn.com.poc.writing.repository.BizAiWritingDialoguesRecordRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizAiWritingDialoguesRecordServiceImpl extends BaseServiceImpl
        implements BizAiWritingDialoguesRecordService {

    @Resource
    private BizAiWritingDialoguesRecordRepository repository;

    public BizAiWritingDialoguesRecordEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizAiWritingDialoguesRecordModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizAiWritingDialoguesRecordConvert.modelToEntity(model);
    }


    public List<BizAiWritingDialoguesRecordEntity> findByExample(BizAiWritingDialoguesRecordEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizAiWritingDialoguesRecordEntity> result = new ArrayList<BizAiWritingDialoguesRecordEntity>();
        BizAiWritingDialoguesRecordModel model = new BizAiWritingDialoguesRecordModel();
        if (example != null) {
            model = BizAiWritingDialoguesRecordConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizAiWritingDialoguesRecordModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAiWritingDialoguesRecordConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAiWritingDialoguesRecordEntity save(BizAiWritingDialoguesRecordEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizAiWritingDialoguesRecordModel model = BizAiWritingDialoguesRecordConvert.entityToModel(entity);
        BizAiWritingDialoguesRecordModel saveModel = this.repository.save(model);
        return BizAiWritingDialoguesRecordConvert.modelToEntity(saveModel);
    }

    public BizAiWritingDialoguesRecordEntity update(BizAiWritingDialoguesRecordEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizAiWritingDialoguesRecordModel model = this.repository.get(entity.getId());

        if (entity.getRole() != null) {
            model.setRole(entity.getRole());
        }
        if (entity.getAgentId() != null) {
            model.setAgentId(entity.getAgentId());
        }
        if (entity.getDialogsId() != null) {
            model.setDialogsId(entity.getDialogsId());
        }
        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getContent() != null) {
            model.setContent(entity.getContent());
        }
        if (entity.getDocumentTitle() != null) {
            model.setDocumentTitle(entity.getDocumentTitle());
        }
        if (entity.getTimestamp() != null) {
            model.setTimestamp(entity.getTimestamp());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        if (entity.getReasoningContent() != null) {
            model.setReasoningContent(entity.getReasoningContent());
        }
        if (entity.getFileUrl() != null) {
            model.setFileUrl(entity.getFileUrl());
        }
        BizAiWritingDialoguesRecordModel saveModel = this.repository.save(model);
        return BizAiWritingDialoguesRecordConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizAiWritingDialoguesRecordModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }


    @Override
    public List<AiWritingDialoguesRecordQueryItem> getDialogueRecord(String dialogueId) {
        AiWritingDialoguesRecordQueryCondition condition = new AiWritingDialoguesRecordQueryCondition();
        condition.setDialogueId(dialogueId);
        return this.sqlDao.query(condition, AiWritingDialoguesRecordQueryItem.class);
    }
}