package cn.com.poc.writing.service.impl;	

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.writing.service.BizAiWritingExampleService;
import cn.com.poc.writing.model.BizAiWritingExampleModel;
import cn.com.poc.writing.entity.BizAiWritingExampleEntity;
import cn.com.poc.writing.convert.BizAiWritingExampleConvert;
import cn.com.poc.writing.repository.BizAiWritingExampleRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizAiWritingExampleServiceImpl extends BaseServiceImpl
 			 implements BizAiWritingExampleService {
   
   @Resource
   private BizAiWritingExampleRepository repository;
    			 
   public BizAiWritingExampleEntity get(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizAiWritingExampleModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        return BizAiWritingExampleConvert.modelToEntity(model);
   }

       
   public List<BizAiWritingExampleEntity> findByExample(BizAiWritingExampleEntity example,PagingInfo pagingInfo) throws Exception{
        List<BizAiWritingExampleEntity> result = new  ArrayList<BizAiWritingExampleEntity>();
        BizAiWritingExampleModel model = new BizAiWritingExampleModel();
        if (example != null){
            model = BizAiWritingExampleConvert.entityToModel(example);
        }
        List<BizAiWritingExampleModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAiWritingExampleConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAiWritingExampleEntity save(BizAiWritingExampleEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setId(null);
        BizAiWritingExampleModel model = BizAiWritingExampleConvert.entityToModel(entity);
        BizAiWritingExampleModel saveModel =  this.repository.save(model);
        return BizAiWritingExampleConvert.modelToEntity(saveModel);
    }

    public BizAiWritingExampleEntity update(BizAiWritingExampleEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getId(),"update pk can not be null");
        BizAiWritingExampleModel model = this.repository.get(entity.getId());

       if (entity.getType() != null){
        model.setType(entity.getType());
       }
       if (entity.getTitle() != null){
        model.setTitle(entity.getTitle());
       }
       if (entity.getDescription() != null){
        model.setDescription(entity.getDescription());
       }
       if (entity.getQuestion() != null){
        model.setQuestion(entity.getQuestion());
       }
        BizAiWritingExampleModel saveModel =  this.repository.save(model);
        return BizAiWritingExampleConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizAiWritingExampleModel model =  this.repository.get(id);
        if (model != null){
       }
   }
    
}