package cn.com.poc.writing.service.impl;	

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.writing.service.BizAiWritingExampleTypeService;
import cn.com.poc.writing.model.BizAiWritingExampleTypeModel;
import cn.com.poc.writing.entity.BizAiWritingExampleTypeEntity;
import cn.com.poc.writing.convert.BizAiWritingExampleTypeConvert;
import cn.com.poc.writing.repository.BizAiWritingExampleTypeRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizAiWritingExampleTypeServiceImpl extends BaseServiceImpl
 			 implements BizAiWritingExampleTypeService {
   
   @Resource
   private BizAiWritingExampleTypeRepository repository;
    			 
   public BizAiWritingExampleTypeEntity get(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizAiWritingExampleTypeModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        return BizAiWritingExampleTypeConvert.modelToEntity(model);
   }

       
   public List<BizAiWritingExampleTypeEntity> findByExample(BizAiWritingExampleTypeEntity example,PagingInfo pagingInfo) throws Exception{
        List<BizAiWritingExampleTypeEntity> result = new  ArrayList<BizAiWritingExampleTypeEntity>();
        BizAiWritingExampleTypeModel model = new BizAiWritingExampleTypeModel();
        if (example != null){
            model = BizAiWritingExampleTypeConvert.entityToModel(example);
        }
        List<BizAiWritingExampleTypeModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAiWritingExampleTypeConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAiWritingExampleTypeEntity save(BizAiWritingExampleTypeEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setId(null);
        BizAiWritingExampleTypeModel model = BizAiWritingExampleTypeConvert.entityToModel(entity);
        BizAiWritingExampleTypeModel saveModel =  this.repository.save(model);
        return BizAiWritingExampleTypeConvert.modelToEntity(saveModel);
    }

    public BizAiWritingExampleTypeEntity update(BizAiWritingExampleTypeEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getId(),"update pk can not be null");
        BizAiWritingExampleTypeModel model = this.repository.get(entity.getId());

       if (entity.getType() != null){
        model.setType(entity.getType());
       }
       if (entity.getName() != null){
        model.setName(entity.getName());
       }
        BizAiWritingExampleTypeModel saveModel =  this.repository.save(model);
        return BizAiWritingExampleTypeConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizAiWritingExampleTypeModel model =  this.repository.get(id);
        if (model != null){
       }
   }
    
}