package cn.com.poc.writing.service.impl;

import cn.com.poc.writing.query.ExaminationQueryCondition;
import cn.com.poc.writing.query.ExaminationQueryItem;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.writing.service.BizExaminationService;
import cn.com.poc.writing.model.BizExaminationModel;
import cn.com.poc.writing.entity.BizExaminationEntity;
import cn.com.poc.writing.convert.BizExaminationConvert;
import cn.com.poc.writing.repository.BizExaminationRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizExaminationServiceImpl extends BaseServiceImpl
        implements BizExaminationService {

    @Resource
    private BizExaminationRepository repository;

    public BizExaminationEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizExaminationModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizExaminationConvert.modelToEntity(model);
    }


    public List<BizExaminationEntity> findByExample(BizExaminationEntity example, PagingInfo pagingInfo) {
        List<BizExaminationEntity> result = new ArrayList<BizExaminationEntity>();
        BizExaminationModel model = new BizExaminationModel();
        if (example != null) {
            model = BizExaminationConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizExaminationModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizExaminationConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizExaminationEntity save(BizExaminationEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizExaminationModel model = BizExaminationConvert.entityToModel(entity);
        BizExaminationModel saveModel = this.repository.save(model);
        return BizExaminationConvert.modelToEntity(saveModel);
    }

    public BizExaminationEntity update(BizExaminationEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizExaminationModel model = this.repository.get(entity.getId());

        if (entity.getExaminationId() != null) {
            model.setExaminationId(entity.getExaminationId());
        }
        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getTitle() != null) {
            model.setTitle(entity.getTitle());
        }
        if (entity.getQuestionType() != null) {
            model.setQuestionType(entity.getQuestionType());
        }
        if (entity.getTotalScore() != null) {
            model.setTotalScore(entity.getTotalScore());
        }
        if (entity.getN() != null) {
            model.setN(entity.getN());
        }
        if (entity.getLevel() != null) {
            model.setLevel(entity.getLevel());
        }
        if (entity.getLanguage() != null) {
            model.setLanguage(entity.getLanguage());
        }
        if (entity.getPositions() != null) {
            model.setPositions(entity.getPositions());
        }
        if (entity.getExaminationDetail() != null) {
            model.setExaminationDetail(entity.getExaminationDetail());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizExaminationModel saveModel = this.repository.save(model);
        return BizExaminationConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizExaminationModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

    @Override
    public List<ExaminationQueryItem> examinationQuery(ExaminationQueryCondition condition, PagingInfo pagingInfo) {
        return this.sqlDao.query(condition, ExaminationQueryItem.class, pagingInfo);
    }
}