package cn.com.poc.agent_application;

import cn.com.poc.agent_application.entity.BizAgentApplicationApiProfileEntity;
import cn.com.poc.agent_application.service.BizAgentApplicationApiProfileService;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.expose.aggregate.AgentApplicationExposeService;
import cn.com.poc.expose.dto.AgentApplicationApiProfileDto;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

/**
 * @author alex.yao
 * @date 2024/12/19
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class AgentApplicationApiProfileTest {

    @Resource
    private BizAgentApplicationApiProfileService bizAgentApplicationApiProfileService;

    @Test
    public void test_initProfile() throws Exception, NoSuchAlgorithmException, UnsupportedEncodingException {
        bizAgentApplicationApiProfileService.initProfile(197L);
    }

    @Resource
    private AgentApplicationExposeService agentApplicationExposeService;

    @Test
    public void test_getApiProfile() {
        String agentId = "d37d4a9b2fe0421ea991127c247fbbf3";
        BizAgentApplicationApiProfileEntity apiProfileEntity = agentApplicationExposeService.getApiProfile(197L);
        AgentApplicationApiProfileDto result = new AgentApplicationApiProfileDto();
        result.setApiKey(apiProfileEntity.getApiKey());
        result.setApiSecret(apiProfileEntity.getApiSecret());
        System.out.println(JsonUtils.serialize(result));
    }
}
