package cn.com.poc.ai_bi;

import cn.com.poc.common.utils.DocumentLoad;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Map;
import java.util.Set;

/**
 * @author 52747
 * @date 2025/8/21
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class AIBiTest {

    @Test
    public void test_readCSVHeader() {
        String fileUrl = "https://gsst-poe-sit.gz.bcebos.com/v1/weather_district_id.csv";
        File file = DocumentLoad.downloadURLDocument(fileUrl);

        try (Reader reader = new FileReader(file)) {
            CSVParser csvParser = new CSVParser(reader, CSVFormat.DEFAULT
                    .withFirstRecordAsHeader()
                    .withIgnoreHeaderCase()
                    .withTrim());
            Map<String, Integer> headerMap = csvParser.getHeaderMap();
            Set<String> headerSet = headerMap.keySet();
            System.out.println(JsonUtils.serialize(headerSet));

        } catch (Exception e) {
            throw new BusinessException("获取文件失败");
        }
    }

}
