package cn.com.poc.data_analyze.query;

import cn.com.poc.common.utils.DateUtils;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.data_analyze.service.BizDataAnalyzeDialogueRecordService;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.runner.RunWith;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.List;

/**
 * @author alex.yao
 * @date 2024/12/11
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class AgentDataTrendQueryTest {

    @Resource
    private BizDataAnalyzeDialogueRecordService bizDataAnalyzeDialogueRecordService;


    @Test
    public void test() {
        Date currDateTime = DateUtils.getCurrDateTime();
        Date date = DateUtils.addDays(currDateTime, -7);
        //1. 获取本月第一周的日期范围
        Date thisWeekBegin = DateUtils.getWeekBegin2(currDateTime);
        Date thisWeekEnd = DateUtils.getWeekEnd2(currDateTime);

        // 输出结果
        System.out.println("本月第一周的起始日期: " + DateUtils.formatDate(thisWeekBegin, DateUtils.yyyy_MM_dd_HH_mm_ss));
        System.out.println("本月第一周的结束日期: " + DateUtils.formatDate(thisWeekEnd, DateUtils.yyyy_MM_dd_HH_mm_ss));
        System.out.println("本月第一周的结束日期: " + DateUtils.formatDate(date, DateUtils.yyyy_MM_dd_HH_mm_ss));
    }
}
