package cn.com.poc.equity.aggregate;


import cn.com.poc.common.utils.DateUtils;
import cn.com.poc.equity.constants.EquityEnum;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.MockitoAnnotations;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;

import java.util.Date;

import static org.junit.Assert.assertNotNull;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class EquityServiceTest {

    @InjectMocks
    @Resource
    private EquityService equityService;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void test_createEquityOrder() {
        Long memberId = 197L;
        EquityEnum.TYPE type = EquityEnum.TYPE.professional;
        EquityEnum.DOMAIN domain = EquityEnum.DOMAIN.equity;
        EquityEnum.VALIDITY_UNIT validityUnit = EquityEnum.VALIDITY_UNIT.year;
        String equityOrder = null;
        try {
            equityOrder = equityService.createEquityOrder(type, domain, validityUnit, memberId);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        assertNotNull(equityOrder);
        System.out.println("创建订单：" + equityOrder);
    }

    @Test
    public void test_calculateRemainExpiredDay() {
        EquityEnum.VALIDITY_UNIT validityUnit = EquityEnum.VALIDITY_UNIT.year;
        Date now = DateUtils.getCurrDateTime();
        Date payTime = DateUtils.addDays(now, -2);
        Integer expiredNum = 1;
        int diff = 0;
        Date expiredDate;
        switch (validityUnit) {
            case month:
                expiredDate = DateUtils.addMonth(payTime, expiredNum);
                diff = DateUtils.diffTwoDateDay(expiredDate, now);
                break;
            case year:
                expiredDate = DateUtils.addYear(payTime, expiredNum);
                diff = DateUtils.diffTwoDateDay(expiredDate, now);
                break;
            case indefinite:
                System.out.println(-1);
        }
        System.out.println(Math.max(diff, 0));
    }
}
