package cn.com.poc.equity.rest;

import cn.com.poc.common.utils.BlContext;
import cn.com.poc.equity.constants.EquityEnum;
import cn.com.poc.equity.dto.EquityOrderCreateDto;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.MockedStatic;
import org.mockito.MockitoAnnotations;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

import static org.junit.Assert.assertNotNull;
import static org.mockito.Mockito.mockStatic;


@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class EquityOrderRestTest {

    @Resource
    @InjectMocks
    EquityOrderRest equityOrderRest;


    private EquityOrderCreateDto createDto;
    private UserBaseEntity userBaseEntity;
    MockedStatic<BlContext> blContextMockedStatic;


    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
        createDto = new EquityOrderCreateDto();
        createDto.setType(EquityEnum.TYPE.ultimate.name());
        createDto.setDomain(EquityEnum.DOMAIN.equity.name());
        createDto.setValidityUnit(EquityEnum.VALIDITY_UNIT.month.name());
        userBaseEntity = new UserBaseEntity();
        userBaseEntity.setUserId(197L);
        blContextMockedStatic = mockStatic(BlContext.class);
    }

    @Test(expected = Exception.class)
    public void testCreateOrder_UserNotLogin() throws Exception {
        blContextMockedStatic.when(BlContext::getCurrentUserNotException).thenReturn(null);
        equityOrderRest.createOrder(createDto);
    }

    @Test
    @Transactional
    @Rollback
    public void test_createEquityOrder() throws Exception {
        EquityOrderCreateDto equityOrderCreateDto = new EquityOrderCreateDto();
        equityOrderCreateDto.setType(EquityEnum.TYPE.ultimate.name());
        equityOrderCreateDto.setDomain(EquityEnum.DOMAIN.equity.name());
        equityOrderCreateDto.setValidityUnit(EquityEnum.VALIDITY_UNIT.month.name());
        blContextMockedStatic.when(BlContext::getCurrentUserNotException).thenReturn(userBaseEntity);
        String order = equityOrderRest.createOrder(equityOrderCreateDto);
        assertNotNull(order);
    }

    @After
    public void close() {
        blContextMockedStatic.close();
    }
}
