package cn.com.poc.knowledge;

import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.knowledge.convert.BizKnowledgeDatabaseConvert;
import cn.com.poc.knowledge.dto.BizKnowledgeDatabaseDto;
import cn.com.poc.knowledge.entity.BizKnowledgeDatabaseEntity;
import cn.com.poc.knowledge.service.BizKnowledgeDatabaseService;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.runner.RunWith;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;

/**
 * @author alex.yao
 * @date 2025/4/28
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class DatabaseTest {

    @Resource
    private BizKnowledgeDatabaseService bizKnowledgeDatabaseService;

    @Test
    public void create() {
        BizKnowledgeDatabaseDto dto = new BizKnowledgeDatabaseDto();
        dto.setTitle("G");
        dto.setDesc("g");
        dto.setDbType("MYSQL");
        dto.setDbHost("g");
        dto.setDbPort(3306);
        dto.setDbName("G");
        dto.setDbUsername("G");
        dto.setDbPassword("G");
        Long userId = 1L;
        BizKnowledgeDatabaseEntity bizKnowledgeDatabaseEntity = BizKnowledgeDatabaseConvert.dtoToEntity(dto);
        bizKnowledgeDatabaseEntity.setMemberId(userId.intValue());
        BizKnowledgeDatabaseEntity saveEntity = bizKnowledgeDatabaseService.save(bizKnowledgeDatabaseEntity);
        if (saveEntity == null) {
            throw new BusinessException("create database error");
        }
        System.out.println(BizKnowledgeDatabaseConvert.entityToDto(saveEntity));
    }
}
