package cn.com.poc.meeting;

import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.common.utils.UUIDTool;
import cn.com.poc.thirdparty.resource.simultanous_interpretation.entity.AsrOfflineDetailResult;
import cn.com.poc.thirdparty.resource.simultanous_interpretation.service.ASRService;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class ASRTest {


    @Resource
    private ASRService asrService;

    @Test
    public void test_speechToText() {
        String fileUrl = "https://gsst-poe-sit.gz.bcebos.com/data/20250811/1754897064286.wav";
        String uuid = UUIDTool.getUUID();
        System.out.println("sessionId : " + uuid);
        String result = asrService.speechToText(uuid, fileUrl);
        System.out.println(result);
    }

    @Test
    public void test_asrGetDetail() {
        String sessionId = "a9ee310bb9754a089cf64429b9e42ea5";
        AsrOfflineDetailResult asrServiceDetail = asrService.getDetail(sessionId);
        System.out.println(JsonUtils.serialize(asrServiceDetail));
    }
}
