package cn.com.poc.meeting;


import cn.com.poc.meeting.analysis.FeaturedQuestionAnalyzer;
import cn.com.poc.meeting.analysis.KeyWordAnalyzer;
import cn.com.poc.meeting.analysis.SummaryAnalyzer;
import cn.com.poc.meeting.analysis.ThemeAnalyzer;
import cn.com.poc.meeting.cache.KeyWordCounter;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import java.util.List;
import java.util.Map;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class AnalysisTest {

    @Test
    public void test_summaryAnalysis() {
        String content = "要帮忙讲一下啊。哎，好，哎，吴老师你好，，就我大概给您介绍一下。\uD83D\uDE0A呃，那个就是我们其实需要用训练的那个数据，主要是两部分啊，一部分是呃咱们现在的那个录音的音频啊，另外一部分是这个基于这个录音音频转的那个文本啊，然后拿这个两部分的数据呢，其实那个模型它在训练的时候，它会提取其中的一些特征啊，主要是发音和识别的结果。因为我们其实是有base的模型的，然后需要去拿这个数据去在这个base模型上啊做进一步的用。优化，所以其实并不会用到这个呃数据里面的真实的数据啊啊，如果咱们自己有这个呃音频或者是转好了文本，我们也可以只提取这个特征，然后呃拿来做训练的这样的一个过程。嗯。这个是技术上，其实我们是不会去保证这个呃数据会泄露出去的这个问题啊。然后我们训练完了，其实并不需要留存这个数据。然后这因为它那个模型基于这个特征学完了之后，它自己就能具备这样识别的能力啊，只有当咱们还需要需要优化的时候，才还在会去做这个进一步的新一轮的训练啊。如果不需要优化的情况下，那么咱们就不需要再去训练它，也不需要依赖于原有的训练数据。啊，是这样的一个情况。\uD83C\uDFBC然后那个第二个就是刚才这那个张宇跟我沟通的时候，也提到了，咱们可能希望能签署保密协议啊，我们拿到这个数据之后，肯定会可以跟他们去配合签这个保密协议啊。然后我们整体的这个工就是处理这个数据的流程，就是我们拿到音频，然后会呃先给到我们自己的这个标注团队去标注这个语音转文本。然后就进入刚才说的这个训练的过程。训练了之后，我们就可以把这个数据给删除了。大概是这样的一个过程，就是整个的数据也不会出百度，都在百度的范围内。所以我们可以以百度的名义来签这个保密协议，来保证您们的这个数据安全。大概是这样的一个呃流程。您看有没有什么问题。呃老师我了解一下说如果签保密协议的话，咱这个流程大概要走多久啊。就咱们百度内部的话。啊，我们可以尽快推，就是我们其实也挺着急的对，但是呃我之前没走过，所以我也不太清楚大概要走多久啊。咱们有保密协议吗？就是呃我刚刚听张宇说，好像之前是有签过了。如果咱们有现成的保密协议，可能我们这边就是去走一下那个呃签署跟盖章的流程，应该就可以了。之前客户是跟我们签的，然后。可能不太一样，我们得跟客户再再讨论一下，说他们有没有针对于语音这一块的呃，之前签的不是语音的是吧，对，是整个整个数据保护的嗯嗯可能是针对语音。Oh.嗯嗯，那我这边大概对是这样，就是对，您可以先先问问客户，他们是不是有现成的一些保密协议。如果没有的话，我们也可以看看嗯，给一个模板或者怎么样的。行啊行啊，没问题啊。这里可以跟客户沟通一下。好嘞，哎，贾俊，我再问一下，就是他现在准备了多少个小时来着。然后刚才尹雪也跟我沟通，他说好像比如说一两百的话，不知道会不会我们模型的效果会不会好。所以这个他有跟我们讲说夫期可以给多少吗？\uD83D\uDE0A呃，目前还没有，就我们期望是说一两百还是太少是吧？嗯，对我们前面是说的要1500，后面好像要那六说有点难度，1500收据起嗯。然后银雪，咱们这边有一个最小值吗？是如果那个没有那个就是测试题的情况下，我们现在很难评估那个大概的量子是多少。因为这个结构呢。对以就是。看看能不能也和客户沟通一下，就是如果他能先找一些就是不含那个客户的这些敏感信息，像他的那个身份啊，然后他的业务的一些什么呃核心数据的那种。然后就看能不能先给我们两个小时的那个嗯就是这种脱敏的数据，然后我们先去摸一下那个base的模型的效果，如果我们大概知道这个再看那个业务上的表现是什么样的，然后我们大概能评估一些量级。区分明白就是老师我再问一下说呃你们对这个。音频有什么比较特别的要求吗？就类似于说呃一些呃音轨呀，或者说一些别的参数之类块嗯，嗯，应该就是那个8K的，然后就是咱们拿出来应该是。。什么格式我还忘了，就是呃可以是双轨的啊，就是我不知道咱们现在是双轨还是单轨，对应该嗯应该应该问题不太大啊，就是双轨还是单轨，主要是8K的这个数据就是没什么问题的那老师那里面如果夹杂一些呃英文呢。因为呃香港那边很多都是粤语和英文去夹杂着说的这种嗯，这这种没有影响。对我们这次其实也是希望因为。其实是那个实际的用户的交互情况本身就是会有这样很多的情况。所以我们也希望能够去正常识别，可以直接把这个数据给过来。然后我们在标注的时候也会对应的去标注，然后让这个模型能够去学习这种加答的问法。尽量把这个效果做上去的。嗯，好，明白了。嗯，就是说呃刚才您是提到说先有两个小时的一个素材给你们去评估一下，说后续大概是需要多。真正的粤语对对，是的，就如果现在咱如果要同步走保密流程，可能也还需要一点时间嘛。就是看能不能他先给出来两个小时脱敏的这样或者量就比较小，他是不是容易走这个流程，我们可以先评估。对要不然这样能比较准的给到这个数据，他可能就后续只有一次流程嘛。如果第一次拿了不够，后续还得再有第二次可能也比较麻烦。。哎，老师，那我理解一下，说，其实如果是普通的粤语素材，呃，在公网上其实有很多这种。这种素材的这种有什么不一样呢？就一定是要客户那边提供嘛哦，因为场景不一样，就是你最终实现的那个效果会差异还挺大的。就是呃我举一下就是非粤语的例子，就是普通话的例子哈，就是我们其实最开始有的那个呃语音的模型也是基于公网，包括像百度自身一些自己的业务。就是百度APP上也有很多那种呃语音搜索的场景的这样的数据，我们其实是会有一个大的这个模型的b的版本的。但是我们一开始去做这个客服业务的场景的时候，他因为像客服的业务里面会有一些专词。然后呃他的那个。大K的数据的一些表现可能还都会不一样。所以我们其实在呃一开始也是先在国内的这个运营商的行业先去做的这个训练，然后再迁移到比如说像金融的行业的时候，呃，就是量级会小很多。然后我们会也还会再去优化一个经营的版本出来。就是你如果希望在这个行业的这个场景下，它的效果能够能够达到比较好的这样的效果，还是需要它的这个实际的业务数据去做迭代和优化的这样一个过。就如果是那种通用的大模型，他可能只能打一个就是基本分及格分，这很难做到比较好。对像我们现在都要求这个自主在80%到85%这样的一个呃效果的指标上面。.哦，明白了，那他需不需要有一些呃，比如说一些客服行业的一些词汇的的素材啊，就是要材呃，对，这个最好是能有了，就是呃我们那个模型，就是训练完了之后，它其实在上层还有一个IDG的模块那个模块其实就是做一些热词。就比如说我们把一些这个行业里面的专词放进去。呃，你可以去相当于一个词。权重的作用，就是他会在这个权重这个词的权重上加强。然后再遇到这个query识别的时候，就会倾向于往这个词上面的这个识别的结果，就是会有一些这样的调优给到客户。但这个就就可以是部署到他那以后，他自己来作优化，就是可以不走这个b的基础模型。对，明白了嗯。好的，那我那我大概明白老师的意思这边的话就呃我们再去跟用户沟通一下，说他前期能提供一些什么样的素材出来。然后方便我们后期的预估啊或者说后期的训练。对，我们我们还是希望这个数据能尽快拿到。就是就是按刚才说的，如果大批量的数据，他们可能会流程或者周期比较长，我可以先看看能不能先给一点，你们先去看看效果。嗯，好的好的，这边我再跟用户沟通一下，就包括已知协议，我们也跟用户再沟通一下，看他什么样的方式是比较方便的。好嘞好嘞嗯，好的。好的，那谢谢需要，谢谢佳俊啊。问题再聊啊。好拜拜拜拜嗯嗯。";

        SummaryAnalyzer summaryAnalyzer = new SummaryAnalyzer();
        String summary = summaryAnalyzer.run(content);
        System.out.println(summary);
    }

    @Test
    public void test_themeAnalysis() {
        String content = "数据训练及保密流程说明  \n" +
                "（一）训练数据需求  \n" +
                "需要两部分数据：录音音频和对应的转写文本。模型训练时仅提取发音特征和识别结果，不会使用真实数据内容。若有现成的音频或文本数据，可直接提取特征用于训练。  \n" +
                "\n" +
                "（二）数据安全与保密  \n" +
                "训练完成后不保留原始数据，模型仅基于学到的特征进行识别。百度内部全程处理数据，可签署保密协议保障数据安全。若需优化模型，需重新训练但无需依赖旧数据。  \n" +
                "\n" +
                "（三）保密协议签署流程  \n" +
                "需确认客户是否有现成保密协议模板（尤其是语音相关条款）。若没有，可提供百度模板或协商新协议。签署周期未明确，但会优先推进。  \n" +
                "\n" +
                "（四）数据量评估与测试  \n" +
                "当前期望1500小时数据，但客户提供难度较大。建议先提供2小时脱敏数据（不含敏感信息）用于测试模型效果，再评估实际需求量。若数据不足可能需多次流程。  \n" +
                "\n" +
                "（五）音频技术要求  \n" +
                "要求8K采样率，单轨/双轨均可。接受粤语与英文混杂的真实场景语音，标注时将保留混合表达以优化模型识别能力。  \n" +
                "\n" +
                "（六）行业数据特殊性  \n" +
                "公网通用数据无法满足特定场景（如客服行业）效果，需客户提供实际业务数据。行业专词可通过独立模块（IDG）后期优化，但基础模型仍需行业数据训练以达到80%-85%准确率。";

        ThemeAnalyzer themeAnalyzer = new ThemeAnalyzer();
        String theme = themeAnalyzer.run(content);
        System.out.println(theme);
    }

    @Test
    public void test_keywordAnalysis() {
        String content = "要帮忙讲一下啊。哎，好，哎，吴老师你好，，就我大概给您介绍一下。\uD83D\uDE0A呃，那个就是我们其实需要用训练的那个数据，主要是两部分啊，一部分是呃咱们现在的那个录音的音频啊，另外一部分是这个基于这个录音音频转的那个文本啊，然后拿这个两部分的数据呢，其实那个模型它在训练的时候，它会提取其中的一些特征啊，主要是发音和识别的结果。因为我们其实是有base的模型的，然后需要去拿这个数据去在这个base模型上啊做进一步的用。优化，所以其实并不会用到这个呃数据里面的真实的数据啊啊，如果咱们自己有这个呃音频或者是转好了文本，我们也可以只提取这个特征，然后呃拿来做训练的这样的一个过程。嗯。这个是技术上，其实我们是不会去保证这个呃数据会泄露出去的这个问题啊。然后我们训练完了，其实并不需要留存这个数据。然后这因为它那个模型基于这个特征学完了之后，它自己就能具备这样识别的能力啊，只有当咱们还需要需要优化的时候，才还在会去做这个进一步的新一轮的训练啊。如果不需要优化的情况下，那么咱们就不需要再去训练它，也不需要依赖于原有的训练数据。啊，是这样的一个情况。\uD83C\uDFBC然后那个第二个就是刚才这那个张宇跟我沟通的时候，也提到了，咱们可能希望能签署保密协议啊，我们拿到这个数据之后，肯定会可以跟他们去配合签这个保密协议啊。然后我们整体的这个工就是处理这个数据的流程，就是我们拿到音频，然后会呃先给到我们自己的这个标注团队去标注这个语音转文本。然后就进入刚才说的这个训练的过程。训练了之后，我们就可以把这个数据给删除了。大概是这样的一个过程，就是整个的数据也不会出百度，都在百度的范围内。所以我们可以以百度的名义来签这个保密协议，来保证您们的这个数据安全。大概是这样的一个呃流程。您看有没有什么问题。呃老师我了解一下说如果签保密协议的话，咱这个流程大概要走多久啊。就咱们百度内部的话。啊，我们可以尽快推，就是我们其实也挺着急的对，但是呃我之前没走过，所以我也不太清楚大概要走多久啊。咱们有保密协议吗？就是呃我刚刚听张宇说，好像之前是有签过了。如果咱们有现成的保密协议，可能我们这边就是去走一下那个呃签署跟盖章的流程，应该就可以了。之前客户是跟我们签的，然后。可能不太一样，我们得跟客户再再讨论一下，说他们有没有针对于语音这一块的呃，之前签的不是语音的是吧，对，是整个整个数据保护的嗯嗯可能是针对语音。Oh.嗯嗯，那我这边大概对是这样，就是对，您可以先先问问客户，他们是不是有现成的一些保密协议。如果没有的话，我们也可以看看嗯，给一个模板或者怎么样的。行啊行啊，没问题啊。这里可以跟客户沟通一下。好嘞，哎，贾俊，我再问一下，就是他现在准备了多少个小时来着。然后刚才尹雪也跟我沟通，他说好像比如说一两百的话，不知道会不会我们模型的效果会不会好。所以这个他有跟我们讲说夫期可以给多少吗？\uD83D\uDE0A呃，目前还没有，就我们期望是说一两百还是太少是吧？嗯，对我们前面是说的要1500，后面好像要那六说有点难度，1500收据起嗯。然后银雪，咱们这边有一个最小值吗？是如果那个没有那个就是测试题的情况下，我们现在很难评估那个大概的量子是多少。因为这个结构呢。对以就是。看看能不能也和客户沟通一下，就是如果他能先找一些就是不含那个客户的这些敏感信息，像他的那个身份啊，然后他的业务的一些什么呃核心数据的那种。然后就看能不能先给我们两个小时的那个嗯就是这种脱敏的数据，然后我们先去摸一下那个base的模型的效果，如果我们大概知道这个再看那个业务上的表现是什么样的，然后我们大概能评估一些量级。区分明白就是老师我再问一下说呃你们对这个。音频有什么比较特别的要求吗？就类似于说呃一些呃音轨呀，或者说一些别的参数之类块嗯，嗯，应该就是那个8K的，然后就是咱们拿出来应该是。。什么格式我还忘了，就是呃可以是双轨的啊，就是我不知道咱们现在是双轨还是单轨，对应该嗯应该应该问题不太大啊，就是双轨还是单轨，主要是8K的这个数据就是没什么问题的那老师那里面如果夹杂一些呃英文呢。因为呃香港那边很多都是粤语和英文去夹杂着说的这种嗯，这这种没有影响。对我们这次其实也是希望因为。其实是那个实际的用户的交互情况本身就是会有这样很多的情况。所以我们也希望能够去正常识别，可以直接把这个数据给过来。然后我们在标注的时候也会对应的去标注，然后让这个模型能够去学习这种加答的问法。尽量把这个效果做上去的。嗯，好，明白了。嗯，就是说呃刚才您是提到说先有两个小时的一个素材给你们去评估一下，说后续大概是需要多。真正的粤语对对，是的，就如果现在咱如果要同步走保密流程，可能也还需要一点时间嘛。就是看能不能他先给出来两个小时脱敏的这样或者量就比较小，他是不是容易走这个流程，我们可以先评估。对要不然这样能比较准的给到这个数据，他可能就后续只有一次流程嘛。如果第一次拿了不够，后续还得再有第二次可能也比较麻烦。。哎，老师，那我理解一下，说，其实如果是普通的粤语素材，呃，在公网上其实有很多这种。这种素材的这种有什么不一样呢？就一定是要客户那边提供嘛哦，因为场景不一样，就是你最终实现的那个效果会差异还挺大的。就是呃我举一下就是非粤语的例子，就是普通话的例子哈，就是我们其实最开始有的那个呃语音的模型也是基于公网，包括像百度自身一些自己的业务。就是百度APP上也有很多那种呃语音搜索的场景的这样的数据，我们其实是会有一个大的这个模型的b的版本的。但是我们一开始去做这个客服业务的场景的时候，他因为像客服的业务里面会有一些专词。然后呃他的那个。大K的数据的一些表现可能还都会不一样。所以我们其实在呃一开始也是先在国内的这个运营商的行业先去做的这个训练，然后再迁移到比如说像金融的行业的时候，呃，就是量级会小很多。然后我们会也还会再去优化一个经营的版本出来。就是你如果希望在这个行业的这个场景下，它的效果能够能够达到比较好的这样的效果，还是需要它的这个实际的业务数据去做迭代和优化的这样一个过。就如果是那种通用的大模型，他可能只能打一个就是基本分及格分，这很难做到比较好。对像我们现在都要求这个自主在80%到85%这样的一个呃效果的指标上面。.哦，明白了，那他需不需要有一些呃，比如说一些客服行业的一些词汇的的素材啊，就是要材呃，对，这个最好是能有了，就是呃我们那个模型，就是训练完了之后，它其实在上层还有一个IDG的模块那个模块其实就是做一些热词。就比如说我们把一些这个行业里面的专词放进去。呃，你可以去相当于一个词。权重的作用，就是他会在这个权重这个词的权重上加强。然后再遇到这个query识别的时候，就会倾向于往这个词上面的这个识别的结果，就是会有一些这样的调优给到客户。但这个就就可以是部署到他那以后，他自己来作优化，就是可以不走这个b的基础模型。对，明白了嗯。好的，那我那我大概明白老师的意思这边的话就呃我们再去跟用户沟通一下，说他前期能提供一些什么样的素材出来。然后方便我们后期的预估啊或者说后期的训练。对，我们我们还是希望这个数据能尽快拿到。就是就是按刚才说的，如果大批量的数据，他们可能会流程或者周期比较长，我可以先看看能不能先给一点，你们先去看看效果。嗯，好的好的，这边我再跟用户沟通一下，就包括已知协议，我们也跟用户再沟通一下，看他什么样的方式是比较方便的。好嘞好嘞嗯，好的。好的，那谢谢需要，谢谢佳俊啊。问题再聊啊。好拜拜拜拜嗯嗯。";

        KeyWordAnalyzer keyWordAnalyzer = new KeyWordAnalyzer();
        List<String> keywords = keyWordAnalyzer.run(content);
        keywords.forEach(System.out::println);

        Map<String, Integer> map = KeyWordCounter.keywordCount(content, keywords);
        System.out.println("计数：" + map);
    }

    @Test
    public void test_featuredQuestionAnalysis() {
        String content = "要帮忙讲一下啊。哎，好，哎，吴老师你好，，就我大概给您介绍一下。\uD83D\uDE0A呃，那个就是我们其实需要用训练的那个数据，主要是两部分啊，一部分是呃咱们现在的那个录音的音频啊，另外一部分是这个基于这个录音音频转的那个文本啊，然后拿这个两部分的数据呢，其实那个模型它在训练的时候，它会提取其中的一些特征啊，主要是发音和识别的结果。因为我们其实是有base的模型的，然后需要去拿这个数据去在这个base模型上啊做进一步的用。优化，所以其实并不会用到这个呃数据里面的真实的数据啊啊，如果咱们自己有这个呃音频或者是转好了文本，我们也可以只提取这个特征，然后呃拿来做训练的这样的一个过程。嗯。这个是技术上，其实我们是不会去保证这个呃数据会泄露出去的这个问题啊。然后我们训练完了，其实并不需要留存这个数据。然后这因为它那个模型基于这个特征学完了之后，它自己就能具备这样识别的能力啊，只有当咱们还需要需要优化的时候，才还在会去做这个进一步的新一轮的训练啊。如果不需要优化的情况下，那么咱们就不需要再去训练它，也不需要依赖于原有的训练数据。啊，是这样的一个情况。\uD83C\uDFBC然后那个第二个就是刚才这那个张宇跟我沟通的时候，也提到了，咱们可能希望能签署保密协议啊，我们拿到这个数据之后，肯定会可以跟他们去配合签这个保密协议啊。然后我们整体的这个工就是处理这个数据的流程，就是我们拿到音频，然后会呃先给到我们自己的这个标注团队去标注这个语音转文本。然后就进入刚才说的这个训练的过程。训练了之后，我们就可以把这个数据给删除了。大概是这样的一个过程，就是整个的数据也不会出百度，都在百度的范围内。所以我们可以以百度的名义来签这个保密协议，来保证您们的这个数据安全。大概是这样的一个呃流程。您看有没有什么问题。呃老师我了解一下说如果签保密协议的话，咱这个流程大概要走多久啊。就咱们百度内部的话。啊，我们可以尽快推，就是我们其实也挺着急的对，但是呃我之前没走过，所以我也不太清楚大概要走多久啊。咱们有保密协议吗？就是呃我刚刚听张宇说，好像之前是有签过了。如果咱们有现成的保密协议，可能我们这边就是去走一下那个呃签署跟盖章的流程，应该就可以了。之前客户是跟我们签的，然后。可能不太一样，我们得跟客户再再讨论一下，说他们有没有针对于语音这一块的呃，之前签的不是语音的是吧，对，是整个整个数据保护的嗯嗯可能是针对语音。Oh.嗯嗯，那我这边大概对是这样，就是对，您可以先先问问客户，他们是不是有现成的一些保密协议。如果没有的话，我们也可以看看嗯，给一个模板或者怎么样的。行啊行啊，没问题啊。这里可以跟客户沟通一下。好嘞，哎，贾俊，我再问一下，就是他现在准备了多少个小时来着。然后刚才尹雪也跟我沟通，他说好像比如说一两百的话，不知道会不会我们模型的效果会不会好。所以这个他有跟我们讲说夫期可以给多少吗？\uD83D\uDE0A呃，目前还没有，就我们期望是说一两百还是太少是吧？嗯，对我们前面是说的要1500，后面好像要那六说有点难度，1500收据起嗯。然后银雪，咱们这边有一个最小值吗？是如果那个没有那个就是测试题的情况下，我们现在很难评估那个大概的量子是多少。因为这个结构呢。对以就是。看看能不能也和客户沟通一下，就是如果他能先找一些就是不含那个客户的这些敏感信息，像他的那个身份啊，然后他的业务的一些什么呃核心数据的那种。然后就看能不能先给我们两个小时的那个嗯就是这种脱敏的数据，然后我们先去摸一下那个base的模型的效果，如果我们大概知道这个再看那个业务上的表现是什么样的，然后我们大概能评估一些量级。区分明白就是老师我再问一下说呃你们对这个。音频有什么比较特别的要求吗？就类似于说呃一些呃音轨呀，或者说一些别的参数之类块嗯，嗯，应该就是那个8K的，然后就是咱们拿出来应该是。。什么格式我还忘了，就是呃可以是双轨的啊，就是我不知道咱们现在是双轨还是单轨，对应该嗯应该应该问题不太大啊，就是双轨还是单轨，主要是8K的这个数据就是没什么问题的那老师那里面如果夹杂一些呃英文呢。因为呃香港那边很多都是粤语和英文去夹杂着说的这种嗯，这这种没有影响。对我们这次其实也是希望因为。其实是那个实际的用户的交互情况本身就是会有这样很多的情况。所以我们也希望能够去正常识别，可以直接把这个数据给过来。然后我们在标注的时候也会对应的去标注，然后让这个模型能够去学习这种加答的问法。尽量把这个效果做上去的。嗯，好，明白了。嗯，就是说呃刚才您是提到说先有两个小时的一个素材给你们去评估一下，说后续大概是需要多。真正的粤语对对，是的，就如果现在咱如果要同步走保密流程，可能也还需要一点时间嘛。就是看能不能他先给出来两个小时脱敏的这样或者量就比较小，他是不是容易走这个流程，我们可以先评估。对要不然这样能比较准的给到这个数据，他可能就后续只有一次流程嘛。如果第一次拿了不够，后续还得再有第二次可能也比较麻烦。。哎，老师，那我理解一下，说，其实如果是普通的粤语素材，呃，在公网上其实有很多这种。这种素材的这种有什么不一样呢？就一定是要客户那边提供嘛哦，因为场景不一样，就是你最终实现的那个效果会差异还挺大的。就是呃我举一下就是非粤语的例子，就是普通话的例子哈，就是我们其实最开始有的那个呃语音的模型也是基于公网，包括像百度自身一些自己的业务。就是百度APP上也有很多那种呃语音搜索的场景的这样的数据，我们其实是会有一个大的这个模型的b的版本的。但是我们一开始去做这个客服业务的场景的时候，他因为像客服的业务里面会有一些专词。然后呃他的那个。大K的数据的一些表现可能还都会不一样。所以我们其实在呃一开始也是先在国内的这个运营商的行业先去做的这个训练，然后再迁移到比如说像金融的行业的时候，呃，就是量级会小很多。然后我们会也还会再去优化一个经营的版本出来。就是你如果希望在这个行业的这个场景下，它的效果能够能够达到比较好的这样的效果，还是需要它的这个实际的业务数据去做迭代和优化的这样一个过。就如果是那种通用的大模型，他可能只能打一个就是基本分及格分，这很难做到比较好。对像我们现在都要求这个自主在80%到85%这样的一个呃效果的指标上面。.哦，明白了，那他需不需要有一些呃，比如说一些客服行业的一些词汇的的素材啊，就是要材呃，对，这个最好是能有了，就是呃我们那个模型，就是训练完了之后，它其实在上层还有一个IDG的模块那个模块其实就是做一些热词。就比如说我们把一些这个行业里面的专词放进去。呃，你可以去相当于一个词。权重的作用，就是他会在这个权重这个词的权重上加强。然后再遇到这个query识别的时候，就会倾向于往这个词上面的这个识别的结果，就是会有一些这样的调优给到客户。但这个就就可以是部署到他那以后，他自己来作优化，就是可以不走这个b的基础模型。对，明白了嗯。好的，那我那我大概明白老师的意思这边的话就呃我们再去跟用户沟通一下，说他前期能提供一些什么样的素材出来。然后方便我们后期的预估啊或者说后期的训练。对，我们我们还是希望这个数据能尽快拿到。就是就是按刚才说的，如果大批量的数据，他们可能会流程或者周期比较长，我可以先看看能不能先给一点，你们先去看看效果。嗯，好的好的，这边我再跟用户沟通一下，就包括已知协议，我们也跟用户再沟通一下，看他什么样的方式是比较方便的。好嘞好嘞嗯，好的。好的，那谢谢需要，谢谢佳俊啊。问题再聊啊。好拜拜拜拜嗯嗯。";

        FeaturedQuestionAnalyzer featuredQuestionAnalyzer = new FeaturedQuestionAnalyzer();
        List<String> featuredQuestions = featuredQuestionAnalyzer.run(content);
        featuredQuestions.forEach(System.out::println);
    }


}
