package cn.com.poc.meeting;

import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class MeetingTest {

    @Test
    public void test() {
        String keyword = "an example";
        String text = "This is an example sentence. Another example? Yes, this is an example.";

        // 将关键词转换为正则表达式模式（注意转义特殊字符）
        String regexPattern = Pattern.quote(keyword);

        // 构建匹配句子的正则表达式
        // 匹配以任意标点符号或换行结尾的句子，包含关键词
        // 支持中英文混合关键词匹配
        String sentenceRegex = "[^,，:：;；.。!?！？\\n]*" + regexPattern + "[^,，:：;；.。!?！？\\n]*[,，:：;；.。!?！？\\n]";

        Pattern pattern = Pattern.compile(sentenceRegex, Pattern.CASE_INSENSITIVE);
        Matcher matcher = pattern.matcher(text);

        // 查找并输出匹配的句子
        while (matcher.find()) {
            System.out.println("\"" + matcher.group().trim() + "\"");
        }
    }
}
