package cn.com.poc.thirdparty.resource.demand.ai.function;

import cn.com.poc.agent_application.entity.KnowledgeContentResult;
import cn.com.poc.agent_application.utils.AgentApplicationTools;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dbchain.DBChainResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dialogue.Tool;
import cn.com.poc.thirdparty.resource.demand.ai.entity.function.FunctionCallResult;
import cn.com.poc.thirdparty.resource.demand.ai.function.chart_generate.ChartGenerateFunction;
import cn.com.poc.thirdparty.service.LLMService;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import com.alibaba.fastjson.JSONObject;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/5/12
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class ChartGenerateFunctionTest {

    private final String SYSTEM_PROMPT = "您是一名专业的数据可视化工程师，请根据以下要求生成图表配置：\n" +
            "**主题**：\n" +
            "${theme}\n" +
            "**输入数据**：\n" +
            "上下文提取数据:\n" +
            "${data}\n" +
            "\n" +
            "数据库数据:\n" +
            "${database_result}\n" +
            "\n" +
            "知识库数据:\n" +
            "${knowledge_result}\n" +
            "\n" +
            "**图形类型**：\n" +
            "${chart_type}\n" +
            "\n" +
            "**配置要求**：\n" +
            "1. 图表标题应准确反映数据主题\n" +
            "2. 使用与数据类型匹配的图表子类型（如堆积柱状图、面积折线图等）\n" +
            "3. 坐标轴需要包含单位说明\n" +
            "4. 注意样式，如x轴内容过多时适当调整x轴宽度\n" +
            "5. 实际使用中用户的数据和要求不同，不能直接使用例子进行输出，要按照用户要求的图表进行\n" +
            "\n" +
            "**输出要求**：\n" +
            "- 仅返回可直接用于Markdown的Mermaid配置\n" +
            "- 包含完整的Mermaid配置项\n" +
            "- 严格遵循Mermaid的语法\n" +
            "- 注意中文标题需要带双引号\n" +
            "- 若需要换行则使用</br>代替换行符\n" +
            "请以Mermaid格式返回配置, 思考好了之后再输出，不要输出其他内容，如解释或注释。\n" +
            "\n" +
            "**示例**\n" +
            "**示例1**\n" +
            "问题:帮我将一下数据生成折线图：\n" +
            "输入数据:请求类型 处理部门 平均处理时间 优先级 技术问题 技术部 2小时 高 账单问题 财务部 1工作日 中 其他 客服部 30分钟 低\n" +
            "主题：不同类型请求在各部门的平均处理时间对比\n" +
            "图形类型 ：柱状图\n" +
            "输出：\n" +
            "```mermaid\n" +
            "xychart-beta\n" +
            "    title \"不同类型请求在各部门的平均处理时间对比\"\n" +
            "    x-axis \"请求类型\" [\"技术问题\", \"账单问题\", \"其他\"]\n" +
            "    y-axis \"处理时间\" 0-->10\n" +
            "    bar [2, 8, 0.5]```\n" +
            "```" +
            "\n" +
            "**示例2**\n" +
            "问题: 帮我将一下数据生成折线图\n" +
            "输入数据: 2022-03-15 500000.00 定金 银行转账 YXSK20220315001 1 购房定金 2022-04-01 1500000.00 首付 银行转账 YXSK20220401001 1 首付款30% 2022-10-01 2450000.00 尾款 银行转账 YXSK20221001001 1 银行按揭放款 2022-04-20 500000.00 定金 银行转账 YXSK20220420001 2 购房定金 2022-05-05 1500000.00 首付 银行转账 YXSK20220505001 2 首付款30% 2022-11-01 2550000.00 尾款 银行转账 YXSK20221101001 2 银行按揭放款\n" +
            "主题：购房款项支付情况\n" +
            "图形类型 ：折线图\n" +
            "输出：\n" +
            "```mermaid\n" +
            "xychart-beta\n" +
            "    title \"购房款项支付情况\"\n" +
            "    x-axis \"日期\" [\"2022-03-15\", \"2022-04-01\", \"2022-04-20\", \"2022-05-05\", \"2022-10-01\", \"2022-11-01\"]\n" +
            "    y-axis \"金额(元)\" 0-->3000000\n" +
            "    line [500000, 1500000, 500000, 1500000, 2450000, 2550000]" +
            "```";

    @Resource
    ChartGenerateFunction chartGenerateFunction;

    @Resource
    LLMService llmService;

    @Test
    public void test_doFunction() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("question", "查询销售数据，并生成折线图");
        jsonObject.put("chart_type", "折线图");
        jsonObject.put("theme", "销售数据");
        jsonObject.put("data", "[(datetime.date(2022, 3, 15), Decimal('4450000.00')), (datetime.date(2022, 4, 20), Decimal('4550000.00')), (datetime.date(2022, 5, 10), Decimal('5950000.00')), (datetime.date(2022, 6, 5), Decimal('6050000.00')), (datetime.date(2022, 7, 18), Decimal('3450000.00')), (datetime.date(2022, 8, 22), Decimal('4750000.00')), (datetime.date(2022, 9, 15), Decimal('4850000.00')), (datetime.date(2022, 10, 10), Decimal('6750000.00')), (datetime.date(2022, 11, 5), Decimal('3950000.00')), (datetime.date(2021, 5, 15), Decimal('4950000.00')), (datetime.date(2021, 6, 20), Decimal('4950000.00')), (datetime.date(2021, 7, 10), Decimal('5050000.00')), (datetime.date(2021, 8, 5), Decimal('5050000.00')), (datetime.date(2021, 9, 18), Decimal('5150000.00')), (datetime.date(2021, 10, 22), Decimal('6950000.00')), (datetime.date(2021, 11, 15), Decimal('7050000.00')), (datetime.date(2021, 12, 10), Decimal('7150000.00')), (datetime.date(2022, 1, 5), Decimal('8400000.00')), (datetime.date(2022, 2, 18), Decimal('8500000.00')), (datetime.date(2022, 9, 15), Decimal('4550000.00')), (datetime.date(2022, 10, 10), Decimal('4650000.00')), (datetime.date(2022, 11, 5), Decimal('6350000.00')), (datetime.date(2022, 12, 20), Decimal('3350000.00')), (datetime.date(2023, 1, 15), Decimal('4450000.00')), (datetime.date(2023, 2, 10), Decimal('4550000.00')), (datetime.date(2023, 3, 5), Decimal('4650000.00')), (datetime.date(2023, 4, 20), Decimal('6150000.00')), (datetime.date(2023, 6, 10), Decimal('4750000.00')), (datetime.date(2023, 7, 5), Decimal('4850000.00')), (datetime.date(2023, 8, 20), Decimal('4950000.00')), (datetime.date(2023, 9, 15), Decimal('6850000.00')), (datetime.date(2023, 10, 10), Decimal('6950000.00')), (datetime.date(2023, 11, 5), Decimal('4050000.00')), (datetime.date(2023, 12, 20), Decimal('5400000.00')), (datetime.date(2024, 1, 15), Decimal('5400000.00')), (datetime.date(2024, 2, 10), Decimal('5500000.00')), (datetime.date(2024, 3, 5), Decimal('5500000.00')), (datetime.date(2024, 4, 20), Decimal('5600000.00')), (datetime.date(2024, 5, 15), Decimal('4650000.00')), (datetime.date(2024, 6, 10), Decimal('4750000.00')), (datetime.date(2024, 7, 5), Decimal('6350000.00')), (datetime.date(2024, 8, 20), Decimal('6450000.00')), (datetime.date(2024, 9, 15), Decimal('6550000.00')), (datetime.date(2024, 10, 10), Decimal('3450000.00'))]");
        String content = jsonObject.toJSONString();

        String identifier = "test_function";
        List<DBChainResult> dbChainResults = new ArrayList<>();
        List<KnowledgeContentResult> knowledgeContentResults = new ArrayList<>();

        AbstractFunctionResult<String> result = chartGenerateFunction.doFunction(content, identifier, dbChainResults, knowledgeContentResults);
        System.out.println(result.getFunctionResult());

    }

    @Test
    public void test_functionCall() {
        String[] strings = new String[]{"chart_generate"};
        List<Tool> tools = AgentApplicationTools.buildFunctionConfig(new ArrayList<>(), "N", "test", "test"
                , strings, "N");
        FunctionCallResult functionCallResult = llmService.functionCall("\n" +
                "请求类型 处理部门 平均处理时间 优先级\n" +
                "技术问题 技术部 2小时 高\n" +
                "账单问题 财务部 1工作日 中\n" +
                "其他 客服部 30分钟 低\n" +
                "根据以上数据生成流程图", tools.toArray(new Tool[0]));
        System.out.println(functionCallResult);
    }

    @Test
    public void test_getLLMConfig() {
        System.out.println(chartGenerateFunction.getLLMConfig());
    }

    @Test
    public void test_getSYSTEM_PROMPT() {
        System.out.println(SYSTEM_PROMPT);
    }


}
