package cn.com.poc.thirdparty.resource.demand.ai.function;

import cn.com.poc.common.utils.DocumentLoad;
import cn.com.poc.thirdparty.resource.demand.ai.function.html_reader.HtmlReaderFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.image_ocr.ImageOCRFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.top_search.WeiboTopSearchFunction;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.runner.RunWith;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;
import java.io.File;

/**
 * @author alex.yao
 * @date 2025/1/15
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class ImageOCRFunctionTest {

    @Resource
    ImageOCRFunction imageOCRFunction;

    @Test
    public void testOCR() {
        String content = "{\"query\":\"图片有什么?\",\"image_url\":\"https://ark-project.tos-cn-beijing.volces.com/images/view.jpeg\"}";
        System.out.println(imageOCRFunction.doFunction(content, "test", null, null));
    }

    HtmlReaderFunction htmlReaderFunction = new HtmlReaderFunction();

    @Test
    public void testHtmlReader() {
        String content = "{\"url\":\"https://top.baidu.com/board?tab=realtime\"}";
        System.out.println(htmlReaderFunction.doFunction(content, "test", null, null));
    }

    @Resource
    WeiboTopSearchFunction weiboTopSearchFunction;

    @Test
    public void weibo() {
        System.out.println(weiboTopSearchFunction.getLLMConfig());
    }

    @Test
    public void excelToMarkdown() {
        File file = new File("C:\\Users\\52747\\Desktop\\List of Question Intents and Standard Answers (IDP&DL) (Dec2024).xlsx");
        System.out.println(DocumentLoad.excelToMarkdown(file));
    }

    @Test
    public void loadPPT() {
        System.out.println(DocumentLoad.loadPPT(new File("C:\\Users\\52747\\Documents\\dataset\\中国风.pptx")));
    }

}
