package cn.com.poc.timbre.rest;

import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.timbre.dto.GetTimbreDto;
import cn.com.poc.timbre.entity.BizVoiceTimbreEntity;
import cn.com.poc.timbre.rest.impl.BizVoiceTimbreRest;
import cn.com.poc.timbre.service.BizVoiceTimbreService;
import cn.com.yict.framemax.core.context.Context;
import cn.com.yict.framemax.core.i18n.BundleMessageSourceImplementor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.*;
import org.mockito.junit.MockitoJUnitRunner;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import static org.junit.Assert.*;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.isNull;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

@RunWith(MockitoJUnitRunner.class)
public class BizVoiceTimbreRestTest {
    MockedStatic<Context> mockedContext;
    @Mock
    private BizVoiceTimbreService bizVoiceTimbreService;
    @InjectMocks
    private BizVoiceTimbreRest bizVoiceTimbreRest;

    @Before
    public void setUp() throws Exception {
//               // Given
        List<BizVoiceTimbreEntity> entities = new ArrayList<>();
        BizVoiceTimbreEntity bizVoiceTimbreEntity = new BizVoiceTimbreEntity();
        bizVoiceTimbreEntity.setId(0);
        bizVoiceTimbreEntity.setTimbreId("12341423AA");
        bizVoiceTimbreEntity.setLanguage(0);
        bizVoiceTimbreEntity.setTimbreName("1");
        bizVoiceTimbreEntity.setTimbreNameEn("one");
        bizVoiceTimbreEntity.setTimbreNameTw("一");
        bizVoiceTimbreEntity.setVoiceUrl("http://");
        bizVoiceTimbreEntity.setIsDeleted("N");
        bizVoiceTimbreEntity.setModifiedTime(new Date());
        bizVoiceTimbreEntity.setSysVersion(0);
        entities.add(bizVoiceTimbreEntity);
        when(bizVoiceTimbreService.findByExample(any(), ArgumentMatchers.isNull())).thenReturn(entities);
        when(bizVoiceTimbreService.getByTimbreId(any())).thenReturn(bizVoiceTimbreEntity);
        mockedContext = Mockito.mockStatic(Context.class);
        Context mockContext = mock(Context.class);
        BundleMessageSourceImplementor bundleMessageSource = mock(BundleMessageSourceImplementor.class);

        mockedContext.when(Context::get).thenReturn(mockContext);
        mockedContext.when(Context.get()::getMessageSource).thenReturn(bundleMessageSource);
        when(bundleMessageSource.getCurrentLocale()).thenReturn(Locale.ENGLISH);
    }

    @Test
    public void getTimbreListTest() throws Exception {
        // When
        List<GetTimbreDto> result = bizVoiceTimbreRest.getTimbreList();
        System.out.println("getTimbreListTest:" + JsonUtils.serialize(result));
        // Then
        assertEquals(3, result.size());
    }

    @Test
    public void getTimbreInfo() {
        GetTimbreDto timbreInfo = bizVoiceTimbreRest.getTimbreInfo("12341423AA");
        assertNotNull(timbreInfo);
        System.out.println("timbreInfo:" + JsonUtils.serialize(timbreInfo));

        when(bizVoiceTimbreService.getByTimbreId(any())).thenReturn(isNull());
        timbreInfo = bizVoiceTimbreRest.getTimbreInfo("12341423AA");
        assertNull(timbreInfo);
    }

    @After
    public void close() {
        mockedContext.close();
    }
}
