package cn.com.poc.user.aggregation;

import cn.com.poc.user.entity.MemberInfoEntity;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.MockitoAnnotations;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class MemberInfoServiceTest {

    @Resource
    @InjectMocks
    MemberInfoService memberInfoService;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test(expected = I18nMessageException.class)
    @Rollback
    @Transactional
    public void testUpdateMemberInfoWithEmail() {
        MemberInfoEntity memberInfoEntity = new MemberInfoEntity();
        memberInfoEntity.setEmail("alex.yao@superlinksoft.com");
        memberInfoEntity.setMemberId(217);
        memberInfoService.updateMemberInfo(memberInfoEntity);
    }
}
