package cn.com.poc.utils;

import cn.com.poc.common.service.BosConfigService;
import cn.com.poc.common.utils.DocumentLoad;
import cn.com.poc.common.utils.FileUtils;
import cn.com.poc.common.utils.UUIDTool;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import cn.hutool.core.io.FileUtil;
import cn.hutool.crypto.digest.MD5;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;
import java.io.*;

/**
 * @author alex.yao
 * @date 2025/6/12
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class FileUtilsTest {
    @Resource
    private BosConfigService bosConfigService;

    @Test
    public void test_wordConvertPDF() throws Exception {
        String content = "hello world";
        String suffix = "txt";

        String fileName = UUIDTool.getUUID();
        File tempFile = File.createTempFile(fileName, suffix);

        FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
        fileOutputStream.write(content.getBytes());
        fileOutputStream.flush();
        fileOutputStream.close();

        BufferedInputStream inputStream = FileUtil.getInputStream(tempFile);
        byte[] bytes = new byte[inputStream.available()];
        inputStream.read(bytes);
        String md5 = MD5.create().digestHex(bytes);
        String upload = bosConfigService.uploadFileByByteArray2Oss(bytes, fileName, suffix);

        System.out.println(md5);
        System.out.println(upload);
        tempFile.delete();
    }


    @Test
    public void test_pdf2word() {
        try {
            String pdfFile = "C:\\Users\\52747\\Documents\\dataset\\EMSD_Regulatory_Services_Handbook_LPG16.pdf";
            String wordFile = "C:\\Users\\52747\\Documents\\dataset\\EMSD_Regulatory_Services_Handbook_LPG16.doc";

            // 加载PDF文档
            PDDocument pdfDoc = PDDocument.load(new File(pdfFile));
            int totalPages = pdfDoc.getNumberOfPages();

            // 使用追加模式打开Word文件
            try (Writer writer = new OutputStreamWriter(new FileOutputStream(wordFile, true), "UTF-8")) {
                PDFTextStripper stripper = new PDFTextStripper();
                stripper.setSortByPosition(true);
                for (int i = 1; i <= totalPages; i++) {
                    stripper.setStartPage(i);
                    stripper.setEndPage(i);
                    String pageText = stripper.getText(pdfDoc);

                    // 追加当前页内容
                    writer.write(pageText);
                    writer.write("\f");
                }
            }
            pdfDoc.close();
            System.out.println("总计追加 " + totalPages + " 页到现有文件");
        } catch (IOException e) {
            System.err.println("转换失败：" + e.getMessage());
            e.printStackTrace();
        }
    }

    @Test
    public void test_pdf() {
        File file = new File("D:\\项目\\【W-001】万讯\\【001】香港机场\\Sample Data_2025-10-17\\Sample Document\\WP Data\\WP057940\\1. Work Method Statement - 1.BCJV-3408-Z-00685C Method Statement for Installation of VDC Works(A.pdf");
        String pdfResult = DocumentLoad.documentToText(file);
        System.out.println(pdfResult);
    }

}
