package cn.com.poc.expose.websocket.constant;


import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.expose.websocket.handler.AbstractWsHandler;
import cn.com.poc.expose.websocket.handler.TextToSpeechTencentHandler;

public class WsHandlerMatcher {

    final private static String TEXT_TO_SPEECH_TC = "/websocket/textToSpeechTC.ws";

    public static AbstractWsHandler getWsHandlerClass(String path) {
        if (StringUtils.isBlank(path)) {
            return null;
        }
        AbstractWsHandler handler = null;
        switch (path) {
            case TEXT_TO_SPEECH_TC:
                handler = new TextToSpeechTencentHandler();
                break;
        }
        return handler;
    }
}

