package cn.com.poc.knowledge.model;

import cn.com.yict.framemax.data.model.BaseModelClass;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Model class for biz_knowledge_document
 * 知识库文件表
 */
@Entity
@Table(name = "biz_knowledge_document")
@DynamicInsert
@DynamicUpdate
public class BizKnowledgeDocumentModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * kd_id
     * 主键
     */
    private Integer kdId;

    @Column(name = "kd_id", length = 10)
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public Integer getKdId() {
        return this.kdId;
    }

    public void setKdId(Integer kdId) {
        this.kdId = kdId;
        super.addValidField("kdId");
    }


    /**
     * owner
     * 拥有者：System-系统 、User-用户
     */
    private String owner;

    @Column(name = "owner", length = 10)
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
        super.addValidField("owner");
    }


    /**
     * knowledge_type
     * 知识库类型   QA-问答、Base-基础
     */
    private String knowledgeType;

    @Column(name = "knowledge_type", length = 10)
    public String getKnowledgeType() {
        return this.knowledgeType;
    }

    public void setKnowledgeType(String knowledgeType) {
        this.knowledgeType = knowledgeType;
        super.addValidField("knowledgeType");
    }


    /**
     * document_name
     * 文档名
     */
    private String documentName;

    @Column(name = "document_name", length = 100)
    public String getDocumentName() {
        return this.documentName;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
        super.addValidField("documentName");
    }


    /**
     * document_url
     * 文件下载地址
     */
    private String documentUrl;

    @Column(name = "document_url", length = 225)
    public String getDocumentUrl() {
        return this.documentUrl;
    }

    public void setDocumentUrl(String documentUrl) {
        this.documentUrl = documentUrl;
        super.addValidField("documentUrl");
    }


    /**
     * char_count
     * 文档字符数
     */
    private Long charCount;

    @Column(name = "char_count", length = 19)
    public Long getCharCount() {
        return this.charCount;
    }

    public void setCharCount(Long charCount) {
        this.charCount = charCount;
        super.addValidField("charCount");
    }


    /**
     * upload_time
     * 上传时间
     */
    private java.util.Date uploadTime;

    @Column(name = "upload_time", length = 19)
    public java.util.Date getUploadTime() {
        return this.uploadTime;
    }

    public void setUploadTime(java.util.Date uploadTime) {
        this.uploadTime = uploadTime;
        super.addValidField("uploadTime");
    }

    /**
     * 分片规则
     */
    private String segmentationConfig;

    @Column(name = "segmentation_config", length = 1073741824)
    public String getSegmentationConfig() {
        return segmentationConfig;
    }

    public void setSegmentationConfig(String segmentationConfig) {
        this.segmentationConfig = segmentationConfig;
        super.addValidField("segmentationConfig");
    }

    /**
     * is_enable
     * 是否启用 N-不启用 Y-启用
     */
    private String isEnable;

    @Column(name = "is_enable", length = 1)
    public String getIsEnable() {
        return this.isEnable;
    }

    public void setIsEnable(String isEnable) {
        this.isEnable = isEnable;
        super.addValidField("isEnable");
    }


    /**
     * knowledge_id
     * 中台知识库ID
     */
    private String knowledgeId;

    @Column(name = "knowledge_id", length = 225)
    public String getKnowledgeId() {
        return this.knowledgeId;
    }

    public void setKnowledgeId(String knowledgeId) {
        this.knowledgeId = knowledgeId;
        super.addValidField("knowledgeId");
    }

    /**
     * 文档大小【单位：字节】
     */
    private Long documentSize;

    @Column(name = "document_size", length = 19)
    public Long getDocumentSize() {
        return documentSize;
    }

    public void setDocumentSize(Long documentSize) {
        this.documentSize = documentSize;
        super.addValidField("documentSize");
    }

    /**
     * train_status
     * 状态：未执行-Unopened、 排队-Line 、训练中-Training、 完成-Complete、失败-Fail
     */
    private String trainStatus;

    @Column(name = "train_status", length = 15)
    public String getTrainStatus() {
        return this.trainStatus;
    }

    public void setTrainStatus(String trainStatus) {
        this.trainStatus = trainStatus;
        super.addValidField("trainStatus");
    }


    /**
     * is_deleted
     * 是否删除 Y 是  N 否
     */
    private String isDeleted;

    @Column(name = "is_deleted", length = 1)
    public String getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(String isDeleted) {
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }


    /**
     * CREATOR
     * 创建人
     */
    private String creator;

    @Column(name = "CREATOR", length = 50)
    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
        super.addValidField("creator");
    }


    /**
     * CREATED_TIME
     * 创建时间
     */
    private java.util.Date createdTime;

    @Column(name = "CREATED_TIME", length = 19)
    public java.util.Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(java.util.Date createdTime) {
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }


    /**
     * MODIFIER
     * 修改人
     */
    private String modifier;

    @Column(name = "MODIFIER", length = 50)
    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
        super.addValidField("modifier");
    }


    /**
     * MODIFIED_TIME
     * 修改时间
     */
    private java.util.Date modifiedTime;

    @Column(name = "MODIFIED_TIME", length = 19)
    public java.util.Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(java.util.Date modifiedTime) {
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }


    /**
     * SYS_VERSION
     * 乐观锁,版本号
     */
    private Integer sysVersion;

    @Column(name = "SYS_VERSION", length = 10)
    @Version
    public Integer getSysVersion() {
        return this.sysVersion;
    }

    public void setSysVersion(Integer sysVersion) {
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }


}