package cn.com.poc.support.dgTools.request;

import cn.com.poc.support.dgTools.result.AbstractResult;
import com.fasterxml.jackson.annotation.JsonIgnore;

import java.lang.reflect.ParameterizedType;

/**
 * 微信支付中台调用通用属性
 *
 * @author Roger Wu
 */
public abstract class AbstractRequest<T extends AbstractResult>  {

    /**
     * 交易商户
     */
    private String acctId;

    public String getAcctId() {
        return acctId;
    }

    public void setAcctId(String acctId) {
        this.acctId = acctId;
    }

    public abstract String getMethod() throws Exception;

    @JsonIgnore
    public Class<T> getResponseClass() {
        return (Class<T>) ((ParameterizedType) this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }
}
