package cn.com.poc.expose.aggregate;

import cn.com.poc.agent_application.query.MemberCollectQueryCondition;
import cn.com.poc.agent_application.query.MemberCollectQueryItem;
import cn.com.poc.agent_application.service.BizMemberAgentApplicationCollectService;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.expose.aggregate.impl.AgentApplicationServiceImpl;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.when;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class AgentApplicationServiceTest {
    private BizMemberAgentApplicationCollectService bizMemberAgentApplicationCollectService;

    @Resource
    private AgentApplicationServiceImpl agentApplicationService;

    private Long memberId;
    private PagingInfo pagingInfo;
    private MemberCollectQueryCondition condition;
    private List<MemberCollectQueryItem> memberCollectQueryItems;

    @Before
    public void setUp() {
        memberId = 1L;
        pagingInfo = new PagingInfo();
        condition = new MemberCollectQueryCondition();
        condition.setMemberId(memberId);
        condition.setIsCollect(CommonConstant.YOrN.Y);
        memberCollectQueryItems = new ArrayList<>();
        memberCollectQueryItems.add(new MemberCollectQueryItem());
        bizMemberAgentApplicationCollectService = Mockito.mock(BizMemberAgentApplicationCollectService.class);
    }

    @Test
    public void testGetCollectedApplications() {
        // Mock the behavior of bizMemberAgentApplicationCollectService
        when(bizMemberAgentApplicationCollectService.queryMemberCollect(condition, pagingInfo)).thenReturn(memberCollectQueryItems);

        // Call the method to be tested
        List<MemberCollectQueryItem> result = agentApplicationService.getCollectedApplications(memberId, pagingInfo);


        // Verify that the service method was called with the correct parameters
        Mockito.verify(bizMemberAgentApplicationCollectService).queryMemberCollect(condition, pagingInfo);
    }

    @Test
    public void autoPlayByAgentId() {
        Long memberId = 197L;
        String agentId = "bde291ad70f340458e7c6d8ef572eb59";

        System.out.println(agentApplicationService.autoPlayByAgentId(memberId, agentId));
    }

    @Test
    public void enableAutoPlay() {
        Long memberId = 197L;
        String agentId = "bde291ad70f340458e7c6d8ef572eb59";
        String autoPlay = CommonConstant.YOrN.Y;
        String result = agentApplicationService.enableAutoPlay(memberId, agentId, autoPlay);
        System.out.println(result);
    }

}
