package cn.com.poc.formreport.strategy;

import cn.com.poc.common.utils.BlContext;
import cn.com.poc.data_analyze.entity.AgentDataAnalyzeApiChannelEntity;
import cn.com.poc.expose.aggregate.AgentDataAnalyzeService;
import cn.com.poc.formreport.FormReportRequest;
import cn.com.poc.formreport.entity.ApiChannelReportENEntity;
import cn.com.poc.formreport.entity.ApiChannelReportZHCNEntity;
import cn.com.poc.formreport.entity.ApiChannelReportZHTWEntity;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.stream.Collectors;

import static cn.com.poc.common.constant.XLangConstant.*;

/**
 * Agent应用 API渠道-积分使用数据
 *
 * @author alex.yao
 * @date 2024/12/20
 */
@Component
public class AgentDataAnalyzeApiChannelFormReportStrategy extends AbstractFormReportStrategy implements FormReportStrategy {

    @Resource
    private AgentDataAnalyzeService agentDataAnalyzeService;


    @Override
    public List<Object> getFormReportData(FormReportRequest reportRequest) throws Exception {
        String lang = BlContext.getCurrentLocaleLanguageToLowerCase();
        List<AgentDataAnalyzeApiChannelEntity> analyzeApiChannelEntities = agentDataAnalyzeService.getAgentApiChannelPointCount(reportRequest.getAgentId(), reportRequest.getTimeRange());
        switch (lang) {
            case ZH_CN:
                return analyzeApiChannelEntities.stream().map(value -> {
                    ApiChannelReportZHCNEntity apiChannelReportEntity = new ApiChannelReportZHCNEntity();
                    apiChannelReportEntity.setDateTime(value.getDateTime());
                    apiChannelReportEntity.setCount(BigDecimal.valueOf(value.getCount()).setScale(2, RoundingMode.HALF_UP).doubleValue());
                    return apiChannelReportEntity;
                }).collect(Collectors.toList());
            case EN:
                return analyzeApiChannelEntities.stream().map(value -> {
                    ApiChannelReportENEntity apiChannelReportEntity = new ApiChannelReportENEntity();
                    apiChannelReportEntity.setDateTime(value.getDateTime());
                    apiChannelReportEntity.setCount(BigDecimal.valueOf(value.getCount()).setScale(2, RoundingMode.HALF_UP).doubleValue());
                    return apiChannelReportEntity;
                }).collect(Collectors.toList());
            case ZH_TW:
                return analyzeApiChannelEntities.stream().map(value -> {
                    ApiChannelReportZHTWEntity apiChannelReportEntity = new ApiChannelReportZHTWEntity();
                    apiChannelReportEntity.setDateTime(value.getDateTime());
                    apiChannelReportEntity.setCount(BigDecimal.valueOf(value.getCount()).setScale(2, RoundingMode.HALF_UP).doubleValue());
                    return apiChannelReportEntity;
                }).collect(Collectors.toList());
        }
        return analyzeApiChannelEntities.stream().map(value -> {
            ApiChannelReportENEntity apiChannelReportEntity = new ApiChannelReportENEntity();
            apiChannelReportEntity.setDateTime(value.getDateTime());
            apiChannelReportEntity.setCount(BigDecimal.valueOf(value.getCount()).setScale(2, RoundingMode.HALF_UP).doubleValue());
            return apiChannelReportEntity;
        }).collect(Collectors.toList());
    }


    @Override
    public Class getExcelEntityClass() {
        String lang = BlContext.getCurrentLocaleLanguageToLowerCase();
        switch (lang) {
            case ZH_CN:
                return ApiChannelReportZHCNEntity.class;
            case EN:
                return ApiChannelReportENEntity.class;
            case ZH_TW:
                return ApiChannelReportZHTWEntity.class;
        }
        return ApiChannelReportENEntity.class;
    }

    @Override
    public String getExcelName(FormReportRequest reportRequest) throws Exception {
        return "Agent-Api-Channel";
    }
}
