package cn.com.poc.knowledge.rest;

import cn.com.poc.knowledge.dto.*;
import cn.com.poc.knowledge.entity.BizKnowledgeDatabaseEntity;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Permission(Access.Safety)
public interface DatabaseRest extends BaseRest {

    /**
     * 创建数据库连接信息
     *
     * @param dto
     * @return
     */
    BizKnowledgeDatabaseDto create(@RequestBody BizKnowledgeDatabaseDto dto);

    /**
     * 测试数据库连接
     *
     * @param dto
     * @return
     */
    DatabaseTestContentDto testConnection(@RequestBody BizKnowledgeDatabaseDto dto);

    /**
     * 获取数据库连接信息
     *
     * @param id
     * @return
     */
    BizKnowledgeDatabaseDto get(@RequestParam Integer id);

    /**
     * 获取数据库连接信息根据ID列表
     *
     * @param ids
     * @return
     */
    List<BizKnowledgeDatabaseDto> getByIds(@RequestParam Integer[] ids);


    /**
     * 获取数据库连接信息列表
     *
     * @param knowledgeDatabaseSearchDto
     * @param pagingInfo
     * @return
     */
    List<BizKnowledgeDatabaseDto> getList(@RequestBody KnowledgeDatabaseSearchDto knowledgeDatabaseSearchDto, PagingInfo pagingInfo);

    /**
     * 删除数据库连接信息
     *
     * @param id 数据库信息ID
     * @return 是否删除成功
     */
    boolean delete(@RequestParam Integer id);

    /**
     * 更新数据库连接信息
     *
     * @param dto
     * @return 更新后的数据库连接信息
     */
    BizKnowledgeDatabaseDto update(@RequestBody BizKnowledgeDatabaseDto dto);

    /**
     * 获取数据库表详情信息
     *
     * @param id 数据库信息ID
     * @return 数据库表详情信息列表
     */
    List<BizDatabaseTableInfoDto> getTableInfo(@RequestParam Integer id);

    /**
     * 获取数据库表数据
     *
     * @param dto 数据库表数据查询条件
     * @return 数据库表数据
     */
    DatabaseTableDataDto getTableData(@RequestBody DatabaseTableDataResponseDto dto, PagingInfo pagingInfo);


}