package cn.com.poc.knowledge.service.impl;

import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.knowledge.convert.BizKnowledgeDatabaseConvert;
import cn.com.poc.knowledge.entity.BizKnowledgeDatabaseEntity;
import cn.com.poc.knowledge.model.BizKnowledgeDatabaseModel;
import cn.com.poc.knowledge.query.KnowledgeDatabaseQueryInfoQueryCondition;
import cn.com.poc.knowledge.query.KnowledgeDatabaseQueryInfoQueryItem;
import cn.com.poc.knowledge.repository.BizKnowledgeDatabaseRepository;
import cn.com.poc.knowledge.service.BizKnowledgeDatabaseService;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class BizKnowledgeDatabaseServiceImpl extends BaseServiceImpl
        implements BizKnowledgeDatabaseService {

    @Resource
    private BizKnowledgeDatabaseRepository repository;

    public BizKnowledgeDatabaseEntity get(java.lang.Long id) {
        Assert.notNull(id);
        BizKnowledgeDatabaseModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if (CommonConstant.IsDeleted.Y.equals(model.getIsDeleted())) {
            return null;
        }
        return BizKnowledgeDatabaseConvert.modelToEntity(model);
    }


    public List<BizKnowledgeDatabaseEntity> findByExample(BizKnowledgeDatabaseEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizKnowledgeDatabaseEntity> result = new ArrayList<BizKnowledgeDatabaseEntity>();
        BizKnowledgeDatabaseModel model = new BizKnowledgeDatabaseModel();
        if (example != null) {
            model = BizKnowledgeDatabaseConvert.entityToModel(example);
        }
        model.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizKnowledgeDatabaseModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizKnowledgeDatabaseConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizKnowledgeDatabaseEntity save(BizKnowledgeDatabaseEntity entity) {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted(CommonConstant.IsDeleted.N);
        BizKnowledgeDatabaseModel model = BizKnowledgeDatabaseConvert.entityToModel(entity);
        BizKnowledgeDatabaseModel saveModel = this.repository.save(model);
        return BizKnowledgeDatabaseConvert.modelToEntity(saveModel);
    }

    public BizKnowledgeDatabaseEntity update(BizKnowledgeDatabaseEntity entity) {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizKnowledgeDatabaseModel model = this.repository.get(entity.getId());

        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getTitle() != null) {
            model.setTitle(entity.getTitle());
        }
        if (entity.getDbDesc() != null) {
            model.setDbDesc(entity.getDbDesc());
        }
        if (entity.getDbType() != null) {
            model.setDbType(entity.getDbType());
        }
        if (entity.getDbHost() != null) {
            model.setDbHost(entity.getDbHost());
        }
        if (entity.getDbPort() != null) {
            model.setDbPort(entity.getDbPort());
        }
        if (entity.getDbName() != null) {
            model.setDbName(entity.getDbName());
        }
        if (entity.getDbUsername() != null) {
            model.setDbUsername(entity.getDbUsername());
        }
        if (entity.getDbPassword() != null) {
            model.setDbPassword(entity.getDbPassword());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizKnowledgeDatabaseModel saveModel = this.repository.save(model);
        return BizKnowledgeDatabaseConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) {
        Assert.notNull(id);
        BizKnowledgeDatabaseModel model = this.repository.get(id);
        if (model != null) {
            if (CommonConstant.IsDeleted.N.equals(model.getIsDeleted())) {
                model.setIsDeleted(CommonConstant.IsDeleted.Y);
                this.repository.save(model);
            }
        }
    }

    @Override
    public List<KnowledgeDatabaseQueryInfoQueryItem> queryKnowledgeDatabaseQueryInfo(KnowledgeDatabaseQueryInfoQueryCondition condition, PagingInfo pagingInfo) {
        return this.sqlDao.query(condition, KnowledgeDatabaseQueryInfoQueryItem.class, pagingInfo);
    }

    @Override
    public Integer[] checkIsExist(Integer[] ids, Integer memberId) {
        List<Integer> result = new ArrayList<>();
        for (Integer id : ids) {
            BizKnowledgeDatabaseModel bizKnowledgeDatabaseModel = this.repository.get(id.longValue());
            if (bizKnowledgeDatabaseModel == null
                    || CommonConstant.IsDeleted.Y.equals(bizKnowledgeDatabaseModel.getIsDeleted())
                    || !bizKnowledgeDatabaseModel.getMemberId().equals(memberId)) {
                continue;
            }
            result.add(id);
        }
        return result.toArray(new Integer[0]);
    }
}