package cn.com.poc.support.security.oauth;


import cn.com.poc.support.security.oauth.constants.OauthConstants;
import cn.com.poc.support.security.oauth.entity.MemberResponse;
import cn.com.poc.user.entity.MemberInfoEntity;
import cn.com.poc.user.service.BizMemberInfoService;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.security.authentication.SecurityAuthenticationToken;
import cn.com.yict.framemax.security.oauth.OauthUserManager;
import cn.com.yict.framemax.security.oauth.entity.OauthTokenEntity;
import cn.com.yict.framemax.security.oauth.support.OauthUserManagerImplementor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.security.core.AuthenticationException;

import javax.annotation.Resource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;


public class MultiDomainOauthUserManagerImplementor extends OauthUserManagerImplementor implements OauthUserManager {
    private static final int MAX_SIZE = 50;
    private Map<String, SecurityAuthenticationToken> securityTokenCache = new LinkedHashMap<String, SecurityAuthenticationToken>() {
        protected boolean removeEldestEntry(Entry<String, SecurityAuthenticationToken> eldest) {
            return this.size() >= 50;
        }
    };


    @Resource
    private BizMemberInfoService bizMemberInfoService;

    public MultiDomainOauthUserManagerImplementor() {
    }

    @Override
    public SecurityAuthenticationToken authUser(String oauthCode, String password, String key) throws AuthenticationException {
        if (oauthCode.startsWith(OauthConstants.TypePrefix.MEMBER_DOMAIN)) {
            return doMemberPlatformSecurityAuthenticationToken(oauthCode);
        } else {
            return super.authUser(oauthCode, password, key);
        }
    }


    @Override
    public SecurityAuthenticationToken loadSecurityToken(OauthTokenEntity tokenEntity) {
        if (tokenEntity.getUser().startsWith(OauthConstants.TypePrefix.MEMBER_DOMAIN)) {
            return doMemberPlatformSecurityAuthenticationToken(tokenEntity.getUser());
        } else {
            return super.loadSecurityToken(tokenEntity);
        }
    }

    public SecurityAuthenticationToken doMemberPlatformSecurityAuthenticationToken(String userAccount) {
        SecurityAuthenticationToken securityToken = null;
        String cuttedUserAccount = String.valueOf(StringUtils.substringAfterLast(userAccount, OauthConstants.TypePrefix.MEMBER_DOMAIN));
        try {
            MemberInfoEntity memberInfoModel = bizMemberInfoService.getById(Integer.valueOf(cuttedUserAccount));
            if (memberInfoModel != null) {
                MemberResponse response = new MemberResponse();
                BeanUtils.copyProperties(memberInfoModel, response);
                response.setUserAccount(userAccount);
                response.setUserName(memberInfoModel.getNickName());
                securityToken = new SecurityAuthenticationToken(response, null, null);
            }
        } catch (Exception e) {
            throw new I18nMessageException(e.getMessage());
        }
        return securityToken;
    }

}
