package cn.com.poc.thirdparty.resource.baidu.utils;


import cn.com.poc.thirdparty.resource.baidu.constants.BaiduApiErrorEnum;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

/**
 * @author alex.yao
 * @date 2023/3/7
 **/
public class BaiduUtils {

    public static String getErrorMsgByErrorCode(Integer errorCode) {
        for (BaiduApiErrorEnum baiduApiError : BaiduApiErrorEnum.values()) {
            if (baiduApiError.getErrorCode().equals(errorCode)) {
                return baiduApiError.getErrorMessage();
            }
        }
        return "Invocation error";
    }

    public static String getDigitalhuman(String appId, String appKey) {
        String expiredTime = ZonedDateTime.now().plusHours(1).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        // token eg: i-khpg99yk2j3gk/7dcefadebec0ee51f312ef1344d1d1cda9db4e35de7279ac7438823b5db96887/2020-10-28T19:40:58.963441+08:00
        HmacUtils hmac = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, appKey);
        return appId + "/" + hmac.hmacHex(appId + expiredTime) + "/" + expiredTime;
    }
}
