package cn.com.poc.thirdparty.resource.demand.ai.aggregate;

import cn.com.poc.thirdparty.resource.demand.ai.entity.generations.*;

import javax.servlet.http.HttpServletResponse;

/**
 * @author alex.yao
 * @date 2023/5/30
 *
 * 图片创建
 **/
public interface AICreateImageService {
    /**
     * 调用OpenAi创建图片接口
     */
    GenerationsResult invokeCreateImage(GenerationsRequest request) throws Exception;

    /**
     * 调用Baidu创建图片接口(普通版)
     */
    GenerationsResult invokeCreateImage(BaiduGenerationsRequest request) throws Exception;

    /**
     * 调用Baidu创建图片接口(高级版)
     */
    GenerationsResult invokeCreateImageV2(BaiduGenerationsV2Request request) throws Exception;

    /**
     * 调用Baidu千帆大模型文生图
     * Stable-Diffusion-XL是业内知名的跨模态大模型，由StabilityAI研发并开源，有着业内领先的图像生成能力。
     */
    BaiduAISailsText2ImageResult executeSailsText2Image(BaiduAISailsText2ImageRequest request) throws Exception;

    /**
     * 千帆大模型图生文
     * Fuyu-8B是由Adept AI训练的多模态图像理解模型，可以支持多样的图像分辨率，回答图形图表有关问题。模型在视觉问答和图像描述等任务上表现良好。
     */
    BaiduAISailsImage2TextResult executeSailsImage2Text(BaiduAISailsImage2TextRequest request, HttpServletResponse httpServletResponse) throws Exception;

}
