package cn.com.poc.thirdparty.resource.demand.ai.function;

import cn.com.poc.common.utils.SpringUtils;
import cn.com.poc.thirdparty.resource.demand.ai.function.calculator.CalculatorFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.chart_generate.ChartGenerateFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.document_reader.DocumentReaderFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.document_understanding.DocumentUnderstandIngFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.extraction.ContractExtractionFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.html_reader.HtmlReaderFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.image_ocr.ImageOCRFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.long_document_reader.LongDocumentReaderFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.long_memory.SetLongMemoryFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.memory_variable_writer.MemoryVariableWriterFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.notification_reminder.NotificationReminderFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.text_in_pdf2md.PdfToMDFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.oa_form.TraveReimbursementlFormFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.oa_form.TravelFormFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.top_search.DouyinTopSearchFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.top_search.ToutiaoTopSearchFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.top_search.WeiboTopSearchFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.web_seach.WebSearchFunction;

public enum LargeModelFunctionEnum {
    calculator(CalculatorFunction.class),
    set_long_memory(SetLongMemoryFunction.class),
    memory_variable_writer(MemoryVariableWriterFunction.class),
    html_reader(HtmlReaderFunction.class),
    document_reader(DocumentReaderFunction.class),
    document_understanding(DocumentUnderstandIngFunction.class),
    web_search(WebSearchFunction.class),

    image_ocr(ImageOCRFunction.class),
    weibo_search_top(WeiboTopSearchFunction.class),

    notification_reminder(NotificationReminderFunction.class),

    toutiao_search_top(ToutiaoTopSearchFunction.class),

    douyin_search_top(DouyinTopSearchFunction.class),

    bing_web_search(null),

    completion_of_travel_form(TravelFormFunction.class),

    completion_of_travel_reimbursement_form(TraveReimbursementlFormFunction.class),

    pdf_to_md(PdfToMDFunction.class),

    long_document_reader(LongDocumentReaderFunction.class),

    contract_extraction(ContractExtractionFunction.class),

    chart_generate(ChartGenerateFunction.class),

    ;

    private Class<? extends AbstractLargeModelFunction> function;

    LargeModelFunctionEnum(Class<? extends AbstractLargeModelFunction> function) {
        this.function = function;
    }

    public AbstractLargeModelFunction getFunction() {
        return SpringUtils.getBean(function);
    }

    public void setFunction(Class<AbstractLargeModelFunction> function) {
        this.function = function;
    }

    public static LargeModelFunctionEnum getFunction(String functionName) {
        for (LargeModelFunctionEnum value : LargeModelFunctionEnum.values()) {
            if (value.name().equals(functionName)) {
                return value;
            }
        }
        return null;
    }
}
