package cn.com.poc.thirdparty.resource.demand.ai.plugin_business.service.impl;

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.thirdparty.resource.demand.ai.plugin_business.service.BizPluginBusinessService;
import cn.com.poc.thirdparty.resource.demand.ai.plugin_business.model.BizPluginBusinessModel;
import cn.com.poc.thirdparty.resource.demand.ai.plugin_business.entity.BizPluginBusinessEntity;
import cn.com.poc.thirdparty.resource.demand.ai.plugin_business.convert.BizPluginBusinessConvert;
import cn.com.poc.thirdparty.resource.demand.ai.plugin_business.repository.BizPluginBusinessRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizPluginBusinessServiceImpl extends BaseServiceImpl
 			 implements BizPluginBusinessService {
   
   @Resource
   private BizPluginBusinessRepository repository;
    			 
   public BizPluginBusinessEntity get(Integer id) throws Exception{
        Assert.notNull(id);
        BizPluginBusinessModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        if ("Y".equals(model.getIsDeleted())){
            return null;
        }
        return BizPluginBusinessConvert.modelToEntity(model);
   }

       
   public List<BizPluginBusinessEntity> findByExample(BizPluginBusinessEntity example,PagingInfo pagingInfo) throws Exception{
        List<BizPluginBusinessEntity> result = new  ArrayList<BizPluginBusinessEntity>();
        BizPluginBusinessModel model = new BizPluginBusinessModel();
        if (example != null){
            model = BizPluginBusinessConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizPluginBusinessModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizPluginBusinessConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizPluginBusinessEntity save(BizPluginBusinessEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setFormId(null);
        entity.setIsDeleted("N");
        BizPluginBusinessModel model = BizPluginBusinessConvert.entityToModel(entity);
        BizPluginBusinessModel saveModel =  this.repository.save(model);
        return BizPluginBusinessConvert.modelToEntity(saveModel);
    }

    public BizPluginBusinessEntity update(BizPluginBusinessEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getFormId(),"update pk can not be null");
        BizPluginBusinessModel model = this.repository.get(entity.getFormId());

       if (entity.getFormNo() != null){
        model.setFormNo(entity.getFormNo());
       }
       if (entity.getFormData() != null){
        model.setFormData(entity.getFormData());
       }
       if (entity.getFormType() != null){
        model.setFormType(entity.getFormType());
       }
       if (entity.getIsDeleted() != null){
        model.setIsDeleted(entity.getIsDeleted());
       }
       if (entity.getCreator() != null){
        model.setCreator(entity.getCreator());
       }
       if (entity.getCreatedTime() != null){
        model.setCreatedTime(entity.getCreatedTime());
       }
       if (entity.getModifier() != null){
        model.setModifier(entity.getModifier());
       }
       if (entity.getModifiedTime() != null){
        model.setModifiedTime(entity.getModifiedTime());
       }
       if (entity.getSysVersion() != null){
        model.setSysVersion(entity.getSysVersion());
       }
        BizPluginBusinessModel saveModel =  this.repository.save(model);
        return BizPluginBusinessConvert.modelToEntity(saveModel);
    }

    public void deletedById(Integer id) throws Exception{
        Assert.notNull(id);
        BizPluginBusinessModel model =  this.repository.get(id);
        if (model != null){
            if ("N".equals(model.getIsDeleted())){
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
       }
   }
    
}