package cn.com.poc.thirdparty.resource.demand.ai.route;

import org.apache.http.Header;
import org.apache.http.HttpHeaders;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;

/**
 * 中台API路径常量
 *
 * @author Roger Wu
 */
public interface DgtoolsApiRoute {

    /**
     * 中台路由
     */
    String HEADER_X_ROUTE = "x-route";

    /**
     * 中台令牌
     */
    String HEADER_X_PLATFORM_AUTHORIZATION = "x-platform-authorization";

    Header JSON_HEADER = new BasicHeader(HttpHeaders.CONTENT_TYPE, ContentType.APPLICATION_JSON.toString());

    /**
     * 会员中台路由
     */
    Header MEMBER_HEADER = new BasicHeader(HEADER_X_ROUTE, "member");

    /**
     * 支付中台路由
     */
    Header PAY_HEADER = new BasicHeader(HEADER_X_ROUTE, "pay");

    /**
     * AI中台路由
     */
    Header AI_HEADER = new BasicHeader(HEADER_X_ROUTE, "ai");

    Header CKHOUSE_HEADER = new BasicHeader(HEADER_X_ROUTE, "ck");

    /**
     *
     */
    String HEADER_REQUEST_TOKEN = "x-request-token";

    /**
     * 接口基础路径
     */
    String BASE_URL = "/api/rest/";


    /**
     * 获取应用令牌
     */
    String GET_APP_TOKEN = "projectExpose/getProjectToken.json";

    /**
     * 会员中台接口
     */
    public class MemberPlatform {
        /**
         * 获取中台TOKEN
         */
        public static final String GET_PLATFORM_TOKEN = "authRest/getToken.json";

        /**
         * 创建中台会员
         */
        public static final String CRAETE_DEMAND_MEMBER = "bizProjectMemberRest/createMemberByProjectId.json";

        /**
         * 查询中台会员
         */
        public static final String SEARCH_DEMAND_MEMBER = "bizProjectMemberRest/searchMember.json";
    }


    /**
     * 商家
     */
    public class Merchant {

        /**
         * 创建商家
         */
        public static final String CREATE_MERCHANT = "merchantExpose/createMerchant.json";

        /**
         * 创建商家微信支付配置
         */
        public static final String CREATE_MERCHANT_WX_PAY_CONFIG = "merchantPayConfigExpose/createWxPayConfig.json";

        /**
         * 更新商家微信支付配置
         */
        public static final String UPDATE_MERCHANT_WX_PAY_CONFIG = "merchantPayConfigExpose/updateWxPayConfig.json";

    }

    /**
     * 中台支付
     */
    public interface DgtoolPay {

        /**
         * 支付
         */
        public static final String DO_PAY = "payExpose/doPay.json";


        /**
         * 营销工具
         */
        interface MakrketingTool {

            /**
             * 商家券
             */
            interface Busifavor {

                /**
                 * 创建商家券
                 */
                String CREATE_COUPON = "wxBusifavorExpose/createCoupon.json";

                /**
                 * 查询已创建商家券批次详情信息
                 */
                String QUERY_COUPON_DETAIL = "wxBusifavorExpose/queryCouponDetail.json";

                /**
                 * 核销用户券
                 */
                String VERIFICATION_COUPON = "wxBusifavorExpose/verificationCoupon.json";

                /**
                 * 根据过滤条件查询用户券
                 */
                String CRITERIA_QUERY_COUPON = "wxBusifavorExpose/criteriaQueryCoupon.json";

                /**
                 * 查询用户单张券详情
                 */
                String QUERY_SINGLE_COUPON = "wxBusifavorExpose/querySingleCoupon.json";

                /**
                 * 上传图片后可获得图片url地址。图片url可在微信支付营销相关的API使用，包括商家券、代金券、支付有礼等
                 */
                String IMAGE_UPLOAD = "wxBusifavorExpose/imageUpload.json";

                /**
                 * 设置商家券事件通知地址
                 */
                String SETTING_COUPON_EVENT_ADVICE_SITE = "wxBusifavorExpose/settingCouponEventAdviceSite.json";

                /**
                 * 查询商家券事件通知地址
                 */
                String QUERY_COUPON_EVENT_ADVICE_SITE = "wxBusifavorExpose/queryCouponEventAdviceSite.json";

                /**
                 * 商户修改批次单天发放上限数量或者批次最大发放数量
                 */
                String UPDATE_COUPON_BUDGET = "wxBusifavorExpose/updateCouponBudget.json";

                /**
                 * 修改商家券基本信息
                 */
                String MODIFY_COUPON_DATA = "wxBusifavorExpose/modifyCouponData.json";

                /**
                 * 商户可以在退款之后调用退券api，调用了该接口后，券在用户卡包内正常展示，用户可在有效期内正常使用该优惠券。
                 */
                String APPLY_RETURN_COUPON = "wxBusifavorExpose/applyReturnCoupon.json";

                /**
                 * 使劵失效，通过该接口将单张领取后未核销的券进行失效处理，券失效后无法再被核销
                 */
                String DEACTIVATE_COUPONS = "wxBusifavorExpose/deactivateCoupons.json";

            }

        }

    }

    interface DgtoolsAI {

        String AI_FaceTransformation = "aIRest/invokeAIFaceTransformation.json";

        String AI_CHATGPT = "aIRest/invokeChatGpt.json";

        String AI_REQUEST_RESOURCE = "aIRest/requestResources.json";

        String AI_CHECK_RESOURCE = "aIRest/checkResourceCallAvailable.json";

        String AI_OPENAI_CREATE_IMAGE = "aIRest/invokeOpenaiCreateImage.json";

        String AI_MODERATIONS = "aIRest/invokeModerations.json";

        String AI_BAIDU_CREATE_IMAGE = "aIRest/invokeBaiduCreateImage.json";

        String AI_BAIDU_CREATE_IMAGE_V2 = "aIRest/invokeBaiduCreateImageV2.json";

        String HOT_LIST = "aIRest/hotList.json";

        String SEARCH_NEWS = "aIRest/searchNews.json";

        String VEIN_LIST = "aIRest/veinList.json";

        String BAIDU_TEXT_CENSOR = "aIRest/textCensor.json";

        String BAIDU_AI_CUSTOM = "aIRest/aiCustom.json";

        String BAIDU_LAW_PLUGIN = "aIRest/lowPlugin.json";

        String BAIDU_PLUGIN = "aIRest/plugin.json";

        /**
         * 百度千帆文生图
         */
        String AI_BAIDU_SAILS_TEXT_CREATE_IMAGE = "aIRest/executeSailsText2Image.json";

        /**
         * 百度千帆图生文
         */
        String AI_BAIDU_SAILS_IMAGE_CREATE_TEXT = "aIRest/executeSailsImage2Text.json";
        ;

        String BAIDU_LIBRARY_PLUGIN = "aIRest/libraryPlugin.json";

        String BAIDU_TEXT_CORRECTION = "aIRest/textCorrection.json";

        String BAIDU_HANDWRITING = "aIRest/handWriting.json";

        /**
         * 知识库
         */
        String TRAIN_KNOWLEDGE = "knowLedgeRest/trainKnowLedge.json";
        String TRAIN_KNOWLEDGE_EVENT = "knowLedgeRest/trainKnowLedgeEvent.json";


        String TRAIN_KNOWLEDGE_STATUS = "/knowLedgeRest/trainKnowLedgeStatus.json";
        String DEL_KNOWLEDGE = "knowLedgeRest/delKnowLedge.json";

        String SEARCH_KNOWLEDGE = "knowLedgeRest/searchKnowledge.json";
        String GET_KNOWLEDGE_CHUNK_INFOS = "/knowLedgeRest/getKnowledgeChunkInfos.json";
        String OPEN_KNOWLEDGE_CHUNK = "/knowLedgeRest/openKnowledgeChunk.json";
        String DELETE_KNOWLEDGE_CHUNK = "/knowLedgeRest/deleteKnowledgeChunk.json";
        String UPDATE_KNOWLEDGE_CHUNK_DOC = "/knowLedgeRest/updateKnowledgeChunkDoc.json";
        String ADD_KNOWLEDGE_CHUNK = "/knowLedgeRest/addKnowledgeChunk.json";

        /**
         * 问答知识库
         */
        String GET_QA_KNOWLEDGE_CHUNK_INFOS = "qAKnowledgeRest/getKnowledgeChunkInfos.json"; //获取问答知识库信息分片

        String ADD_QA_KNOWLEDGE_CHUNK = "qAKnowledgeRest/addKnowledgeChunk.json"; //新增分片

        String UPDATE_QA_KNOWLEDGE_CHUNK = "qAKnowledgeRest/updateKnowledgeChunkDoc.json"; //修改分片内容

        String BATCH_UPDATE_QA_KNOWLEDGE_CHUNK = "qAKnowledgeRest/batchUpdateKnowledgeChunk.json"; //批量修改分片内容

        String DELETE_QA_KNOWLEDGE_CHUNK = "qAKnowledgeRest/deleteKnowledgeChunk.json"; //删除知识库分片

        String BATCH_DELETE_QA_KNOWLEDGE_CHUNK = "qAKnowledgeRest/batchDeleteKnowledgeChunk.json"; //批量删除知识库分片

        String OPEN_QA_KNOWLEDGE_CHUNK = "qAKnowledgeRest/openKnowledgeChunk.json"; //开关知识库分片信息

        String SORT_QA_KNOWLEDGE_CHUNK = "qAKnowledgeRest/updateKnowledgeChunkSort.json"; //更新分片排序

        String UPDATE_QA_KNOWLEDGE_STRUCT = "qAKnowledgeRest/updateKnowledgeStructure.json"; //更新问答知识库结构

        String GET_QA_KNOWLEDGE_STRUCT = "qAKnowledgeRest/getKnowledgeStructure.json"; //获取问答知识库结构


        /**
         * 大模型【通用】
         */
        String LARGE_MODEL = "largeModelRest/completion.json";

        /**
         * Function Call 判断,判断是否需要Function Call
         */
        String FUNCTION_CALL = "largeModelRest/functionCall.json";

        /**
         * DB_CHAIN 调用
         */
        String DATABASE_CHAIN = "largeModelRest/dbChain.json";
    }

    interface ClickHouse {
        String WEB_BROWSE_HARVEST_REPORT = "webBrowseHarvest/report.json";
    }

}
