package cn.com.poc.user.rest;


import cn.com.poc.user.dto.MemberInfoDto;
import cn.com.poc.user.dto.MemberLoginRequestDto;
import cn.com.poc.user.dto.MemberLoginResponseDto;
import cn.com.poc.user.dto.MemberPasswordRequestDto;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Permission(Access.Safety)
public interface BizMemberInfoRest extends BaseRest {

    /**
     * 用户登录
     */
    @Permission(Access.Anonymous)
    MemberLoginResponseDto doLogin(@RequestBody MemberLoginRequestDto memberLoginRequest) throws Exception;

    /**
     * 用户配置密码
     */
    void configureMemberPassword(@RequestBody MemberPasswordRequestDto memberPasswordRequestDto) throws Exception;

    /**
     * 用户更改密码
     *
     * @param authCode 校验码
     * @param password 新密码
     */
    void changeMemberPassword(@RequestParam String authCode, @RequestParam String password) throws Exception;

    /**
     * 用户忘记密码
     */
//    @Permission(Access.Anonymous)
//    void forgetMemberPassword(@RequestBody MemberPasswordRequestDto memberPasswordRequestDto) throws Exception;

    @Permission(Access.Anonymous)
    void forgetMemberPassword(@RequestParam String account, @RequestParam String password, @RequestParam String authCode) throws Exception;

    /**
     * 获取用户信息
     *
     * @return
     */
    MemberInfoDto getCurrentMemberInfo() throws Exception;

    /**
     * 获取用户昵称
     */
    @Permission(Access.Anonymous)
    MemberInfoDto getMemberNickName(@RequestParam Long memberId) throws Exception;


    /**
     * 修改用户信息
     */
    MemberInfoDto updateMemberInfo(@RequestBody MemberInfoDto memberInfoDto);
}