package cn.com.poc.thirdparty.resource.demand.ai.function;

import cn.com.poc.agent_application.entity.KnowledgeContentResult;
import cn.com.poc.agent_application.utils.AgentApplicationTools;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dbchain.DBChainResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dialogue.Tool;
import cn.com.poc.thirdparty.resource.demand.ai.entity.function.FunctionCallResult;
import cn.com.poc.thirdparty.resource.demand.ai.function.chart_generate.ChartGenerateFunction;
import cn.com.poc.thirdparty.service.LLMService;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import com.alibaba.fastjson.JSONObject;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/5/12
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class ChartGenerateFunctionTest {

    @Resource
    ChartGenerateFunction chartGenerateFunction;

    @Resource
    LLMService llmService;

    @Test
    public void test_doFunction() {
//        String json = "{\"chart_type\": \"折线图\", \"data\": \"2022-03-15 500000.00 定金 银行转账 YXSK20220315001 1 购房定金 2022-04-01 1500000.00 首付 银行转账 YXSK20220401001 1 首付款30% 2022-10-01 2450000.00 尾款 银行转账 YXSK20221001001 1 银行按揭放款 2022-04-20 500000.00 定金 银行转账 YXSK20220420001 2 购房定金 2022-05-05 1500000.00 首付 银行转账 YXSK20220505001 2 首付款30% 2022-11-01 2550000.00 尾款 银行转账 YXSK20221101001 2 银行按揭放款\", \"question\": \"帮我将一下数据生成折线图\", \"theme\": \"购房款项支付情况\"}'}";

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("question", "帮我将一下数据生成折线图");
        jsonObject.put("chart_type", "折线图");
        jsonObject.put("theme", "购房款项支付情况");
        jsonObject.put("data", "2022-03-15 500000.00 定金 银行转账 YXSK20220315001 1 购房定金 2022-04-01 1500000.00 首付 银行转账 YXSK20220401001 1 首付款30% 2022-10-01 2450000.00 尾款 银行转账 YXSK20221001001 1 银行按揭放款 2022-04-20 500000.00 定金 银行转账 YXSK20220420001 2 购房定金 2022-05-05 1500000.00 首付 银行转账 YXSK20220505001 2 首付款30% 2022-11-01 2550000.00 尾款 银行转账 YXSK20221101001 2 银行按揭放款");
        String content = jsonObject.toJSONString();

        String identifier = "test_function";
        List<DBChainResult> dbChainResults = new ArrayList<>();
        List<KnowledgeContentResult> knowledgeContentResults = new ArrayList<>();

        AbstractFunctionResult<String> result = chartGenerateFunction.doFunction(content, identifier, dbChainResults, knowledgeContentResults);
        System.out.println(result.getFunctionResult());

    }

    @Test
    public void test_functionCall() {
        String[] strings = new String[]{"chart_generate"};
        List<Tool> tools = AgentApplicationTools.buildFunctionConfig(new ArrayList<>(), "N", "test", "test"
                , strings, "N");
        FunctionCallResult functionCallResult = llmService.functionCall("帮我将一下数据生成折线图\n" +
                " 2022-03-15 500000.00 定金 银行转账 YXSK20220315001 1 购房定金\n" +
                " 2022-04-01 1500000.00 首付 银行转账 YXSK20220401001 1 首付款30%\n" +
                " 2022-10-01 2450000.00 尾款 银行转账 YXSK20221001001 1 银行按揭放款\n" +
                "2022-04-20 500000.00 定金 银行转账 YXSK20220420001 2 购房定金\n" +
                "2022-05-05 1500000.00 首付 银行转账 YXSK20220505001 2 首付款30%\n" +
                " 2022-11-01 2550000.00 尾款 银行转账 YXSK20221101001 2 银行按揭放款\n" +
                "\n", tools.toArray(new Tool[0]));
        System.out.println(functionCallResult);
    }

    @Test
    public void test_getLLMConfig() {
        System.out.println(chartGenerateFunction.getLLMConfig());
    }


}
