package cn.com.poc.equity.convert;	

import cn.com.poc.equity.model.BizMemberPointsModel;
import cn.com.poc.equity.entity.BizMemberPointsEntity;
import cn.com.poc.equity.dto.BizMemberPointsDto;


public class BizMemberPointsConvert {

    public static BizMemberPointsEntity modelToEntity(BizMemberPointsModel model){
        BizMemberPointsEntity entity = new BizMemberPointsEntity();
        entity.setId(model.getId());
        entity.setMemberId(model.getMemberId());
        entity.setTotalPoints(model.getTotalPoints());
        entity.setUsagePoints(model.getUsagePoints());
        entity.setExpiredTime(model.getExpiredTime());
        entity.setIsDeleted(model.getIsDeleted());
        entity.setCreator(model.getCreator());
        entity.setCreatedTime(model.getCreatedTime());
        entity.setModifier(model.getModifier());
        entity.setModifiedTime(model.getModifiedTime());
        entity.setSysVersion(model.getSysVersion());
        return entity;
    }

    public static BizMemberPointsModel entityToModel(BizMemberPointsEntity entity){
        BizMemberPointsModel model = new BizMemberPointsModel();
        model.setId(entity.getId());
        model.setMemberId(entity.getMemberId());
        model.setTotalPoints(entity.getTotalPoints());
        model.setUsagePoints(entity.getUsagePoints());
        model.setExpiredTime(entity.getExpiredTime());
        model.setIsDeleted(entity.getIsDeleted());
        model.setCreator(entity.getCreator());
        model.setCreatedTime(entity.getCreatedTime());
        model.setModifier(entity.getModifier());
        model.setModifiedTime(entity.getModifiedTime());
        model.setSysVersion(entity.getSysVersion());
        return model;
    }
    
    public static BizMemberPointsDto entityToDto(BizMemberPointsEntity entity){
        BizMemberPointsDto dto = new BizMemberPointsDto();
        dto.setId(entity.getId());
        dto.setMemberId(entity.getMemberId());
        dto.setTotalPoints(entity.getTotalPoints());
        dto.setUsagePoints(entity.getUsagePoints());
        dto.setExpiredTime(entity.getExpiredTime());
        dto.setIsDeleted(entity.getIsDeleted());
        dto.setCreator(entity.getCreator());
        dto.setCreatedTime(entity.getCreatedTime());
        dto.setModifier(entity.getModifier());
        dto.setModifiedTime(entity.getModifiedTime());
        dto.setSysVersion(entity.getSysVersion());
        return dto;
    }

    public static BizMemberPointsEntity dtoToEntity(BizMemberPointsDto dto){
        BizMemberPointsEntity entity = new BizMemberPointsEntity();
        entity.setId(dto.getId());
        entity.setMemberId(dto.getMemberId());
        entity.setTotalPoints(dto.getTotalPoints());
        entity.setUsagePoints(dto.getUsagePoints());
        entity.setExpiredTime(dto.getExpiredTime());
        entity.setIsDeleted(dto.getIsDeleted());
        entity.setCreator(dto.getCreator());
        entity.setCreatedTime(dto.getCreatedTime());
        entity.setModifier(dto.getModifier());
        entity.setModifiedTime(dto.getModifiedTime());
        entity.setSysVersion(dto.getSysVersion());
        return entity;
    }
}