package cn.com.poc.expose.rest;

import cn.com.poc.expose.dto.data_statistics.*;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 数据统计接口
 *
 * @author alex.yao
 * @date 2024/12/23
 */
@Permission(Access.Safety)
public interface DataStatisticsRest extends BaseRest {

    /**
     * 平台积分使用情况
     */
    PlatformPointUsageDto platformPointUsage(@RequestParam List<String> channels);

    /**
     * 平台积分使用趋势
     */
    List<PlatformPointTrendDto> platformPointTrend(@RequestBody PlatformPointTrendRequestDto dto);

    /**
     * 平台应用使用情况
     */
    PlatformAgentUsageDto platformAgentUsage(@RequestParam List<String> channels);

    /**
     * 平台应用使用明细
     */
    List<PlatformAgentUsageDetailDto> platformAgentUsageDetail(@RequestBody PlatformAgentUsageDetailRequestDto dto, PagingInfo pagingInfo);
}
