package cn.com.poc.thirdparty.resource.demand.ai.function.top_search;

import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractLargeModelFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.FunctionLLMConfig;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.Parameters;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.Properties;
import cn.com.poc.thirdparty.resource.tianju.api.TianApi;
import cn.com.poc.thirdparty.resource.tianju.api.entity.TianCommonResult;
import cn.com.poc.thirdparty.resource.tianju.api.entity.TianResult;
import cn.com.poc.thirdparty.resource.tianju.api.entity.TianWeiboTopSearch;
import cn.hutool.core.collection.ListUtil;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/1/16
 */
@Component
public class WeiboTopSearchFunction extends AbstractLargeModelFunction {

    private final String DESC = "该方法获取今天微博的热点信息";

    private final FunctionLLMConfig functionLLMConfig = new FunctionLLMConfig.FunctionLLMConfigBuilder()
            .name("weibo_search_top")
            .description(DESC)
//            .parameters(new Parameters("object").addProperties("content", new Properties("string", "内容的详细说明")))
            .build();

    @Resource
    private TianApi tianApi;

    @Override
    public String doFunction(String content, String identifier) {
        TianCommonResult<TianWeiboTopSearch> weiboTopSearch = tianApi.getWeiboTopSearch();
        TianResult<TianWeiboTopSearch> result = weiboTopSearch.getResult();
        List<TianWeiboTopSearch> list = result.getList();
        return JsonUtils.serialize(list);
    }

    @Override
    public String getDesc() {
        return DESC;
    }

    @Override
    public List<String> getLLMConfig() {
        return ListUtil.toList(JsonUtils.serialize(functionLLMConfig));
    }

    @Override
    public List<String> getLLMConfig(List<Variable> variableStructure) {
        return getLLMConfig();
    }
}
