package cn.com.poc.thirdparty.resource.demand.pay.service;

import cn.com.poc.thirdparty.resource.demand.dgTools.result.PayResult;
import cn.com.poc.thirdparty.resource.demand.pay.dto.WxH5PayDto;
import cn.com.poc.thirdparty.resource.demand.pay.dto.WxMiniPayDto;
import cn.com.poc.thirdparty.resource.demand.pay.dto.WxNativePayDto;
import cn.com.yict.framemax.core.service.BaseService;

public interface PayService extends BaseService {

    /**
     * 小程序支付
     *
     * @param wxMiniPayDto
     * @return
     * @throws Exception
     */
    PayResult wxMiniPay(WxMiniPayDto wxMiniPayDto) throws Exception;

    /**
     * H5支付
     */
    PayResult wxH5Pay(WxH5PayDto wxH5PayDto) throws Exception;

    /**
     * Native支付
     */
    PayResult wxNativePay(WxNativePayDto wxNativePayDto) throws Exception;

    //支付宝

    /**
     * 支付宝H5支付 - 电脑网站
     *
     * @return
     * @throws Exception
     */
    PayResult aliPayH5(String payOrderSn) throws Exception;


    /**
     * 支付宝Wap支付 - 手机网站
     *
     * @return
     * @throws Exception
     */
    PayResult aliPayWap(String payOrderSn) throws Exception;


    /**
     * 支付宝Native支付
     *
     * @param payOrderSn
     * @return
     * @throws Exception
     */
    PayResult aliPayNative(String payOrderSn) throws Exception;
}