package cn.com.poc.timbre.rest.impl;

import cn.com.poc.timbre.convert.BizVoiceTimbreConvert;
import cn.com.poc.timbre.dto.GetTimbreDto;
import cn.com.poc.timbre.entity.BizVoiceTimbreEntity;
import cn.com.poc.timbre.service.BizVoiceTimbreService;
import cn.com.yict.framemax.core.context.Context;
import cn.hutool.core.lang.Assert;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import static cn.com.poc.timbre.convert.BizVoiceTimbreConvert.entityToGetTimbreDto;

@Component
public class BizVoiceTimbreRest implements cn.com.poc.timbre.rest.BizVoiceTimbreRest {

    @Resource
    private BizVoiceTimbreService bizVoiceTimbreService;

    @Override
    public List<GetTimbreDto> getTimbreList() throws Exception {
        Locale currentLocale = Context.get().getMessageSource().getCurrentLocale();
        List<GetTimbreDto> result = new ArrayList<>();
        List<BizVoiceTimbreEntity> entities = bizVoiceTimbreService.findByExample(new BizVoiceTimbreEntity(), null);
        if (CollectionUtils.isNotEmpty(entities)) {
            result = BizVoiceTimbreConvert.entitiesToGetTimbreDtoList(entities, currentLocale);
        }
        return result;
    }

    @Override
    public GetTimbreDto getTimbreInfo(String timbreId) {
        Assert.notNull(timbreId);
        BizVoiceTimbreEntity bizVoiceTimbreEntity = bizVoiceTimbreService.getByTimbreId(timbreId);
        if (bizVoiceTimbreEntity == null) {
            return null;
        }
        return entityToGetTimbreDto(bizVoiceTimbreEntity, Context.get().getMessageSource().getCurrentLocale());
    }
}