package cn.com.poc.agent_application.rest;

import cn.com.poc.agent_application.dto.AgentApplicationMallCategoryDto;
import cn.com.poc.agent_application.dto.AgentApplicationMallInfoDto;
import cn.com.poc.agent_application.dto.AgentApplicationMallQueryDto;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.poc.agent_application.dto.BizAgentApplicationMallDto;
import cn.com.yict.framemax.data.model.PagingInfo;

import java.util.List;

import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;

@Permission(value = Access.Safety)
public interface BizAgentApplicationMallRest extends BaseRest {

    /**
     * 配置【已发布的应用】发布至【应用广场】(上架)
     *
     * @return
     */
    void publishAgentToMall(@RequestBody BizAgentApplicationMallDto dto) throws Exception;

    BizAgentApplicationMallDto getById(@RequestParam java.lang.Integer id) throws Exception;

    List<BizAgentApplicationMallDto> getListByExample(@RequestBody BizAgentApplicationMallDto example, PagingInfo pagingInfo) throws Exception;

    /**
     * 获取【应用广场】的应用列表
     */
    List<BizAgentApplicationMallDto> getList(@RequestBody(required = false) AgentApplicationMallQueryDto dto, PagingInfo pagingInfo) throws Exception;

    BizAgentApplicationMallDto update(@RequestBody BizAgentApplicationMallDto dto) throws Exception;

    void deletedById(@RequestParam java.lang.Integer id) throws Exception;

    /**
     * 收藏/取消收藏应用市场中的应用
     *
     * @param id 应用广场中的id
     */
    void collectOrCancelAgentInMall(@RequestParam Integer id) throws Exception;

    /**
     * 下架用户在应用市场中的应用
     *
     * @param agentPublishId 发布应用表的id
     */
    void unSaleAgentInMall(@RequestParam Integer agentPublishId) throws Exception;


    /**
     * 获取应用广场分类列表
     */
    List<AgentApplicationMallCategoryDto> getMallCategoryList(HttpServletRequest httpServletRequest) throws Exception;


    /**
     * 获取应用上架信息
     *
     * @param agentId 应用id
     */
    @Permission(Access.Anonymous)
    AgentApplicationMallInfoDto getMallInfoByAgentId(@RequestParam String agentId) throws Exception;
}