package cn.com.poc.agent_application.rest.impl;	

import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import cn.com.poc.agent_application.rest.BizAgentApplicationDialoguesRecordRest;
import cn.com.poc.agent_application.service.BizAgentApplicationDialoguesRecordService;
import cn.com.poc.agent_application.dto.BizAgentApplicationDialoguesRecordDto;
import cn.com.poc.agent_application.entity.BizAgentApplicationDialoguesRecordEntity;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.poc.agent_application.convert.BizAgentApplicationDialoguesRecordConvert;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

@Component
public class BizAgentApplicationDialoguesRecordRestImpl implements BizAgentApplicationDialoguesRecordRest {
   
   	@Resource
    private BizAgentApplicationDialoguesRecordService service;
    			 
	public BizAgentApplicationDialoguesRecordDto getById(java.lang.Long id) throws Exception{
		Assert.notNull(id);
 		return BizAgentApplicationDialoguesRecordConvert.entityToDto(service.get(id));
   	}
    
   	public List<BizAgentApplicationDialoguesRecordDto> getList(BizAgentApplicationDialoguesRecordDto dto,PagingInfo pagingInfo) throws Exception{
       	return service
		        .findByExample(BizAgentApplicationDialoguesRecordConvert.dtoToEntity(dto),pagingInfo)
		        .stream()
				.map(BizAgentApplicationDialoguesRecordConvert::entityToDto)
				.collect(Collectors.toList());
   	}

   	public BizAgentApplicationDialoguesRecordDto save(BizAgentApplicationDialoguesRecordDto dto) throws Exception{
		Assert.notNull(dto);
		BizAgentApplicationDialoguesRecordEntity entity = BizAgentApplicationDialoguesRecordConvert.dtoToEntity(dto);
       	return BizAgentApplicationDialoguesRecordConvert.entityToDto(service.save(entity));
   	}
    
	
    public BizAgentApplicationDialoguesRecordDto update(BizAgentApplicationDialoguesRecordDto dto) throws Exception{
		Assert.notNull(dto);
		BizAgentApplicationDialoguesRecordEntity entity = BizAgentApplicationDialoguesRecordConvert.dtoToEntity(dto);
       	return BizAgentApplicationDialoguesRecordConvert.entityToDto(service.update(entity));
	}

    public void deletedById(java.lang.Long id) throws Exception{
		Assert.notNull(id);
		service.deletedById(id);
	}
}