package cn.com.poc.common.rest.impl;

import cn.com.poc.common.rest.SmsRest;
import cn.com.poc.common.service.SmsService;
import cn.com.poc.common.utils.Assert;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.regex.Pattern;

@Component
public class SmsRestImpl implements SmsRest {
    @Resource
    private SmsService smsService;

    /**
     * 短信下发（百度SMS）
     *
     * @param phone
     * @throws Exception
     */
    @Override
    public void smsDelivered(String phone) throws Exception {
        Assert.notBlank(phone);
        //校验手机号格式(其中包含大陆和港澳台的校验）
        //正则表达式使用了多个正则模式，每个模式使用|分隔，表示多个模式中的任何一个匹配即可。这样，它可以用于校验多种手机号的格式
        boolean matches = Pattern.matches(
                "(?:0|86|\\+86)?1[3-9]\\d{9}|" + //移动电话MOBILE
                        "(?:0|852|\\+852)?\\d{8}|" + //MOBILE_HK
                        "(?:0|886|\\+886)?(?:|-)09\\d{8}|" + //MOBILE_TW
                        "(?:0|853|\\+853)?(?:|-)6\\d{7}", phone);   //MOBILE_MO
        Assert.isTrue(matches);
        smsService.smsDelivered(phone);
    }

}
