package cn.com.poc.expose.aggregate.impl;

import cn.com.poc.agent_application.aggregate.AgentApplicationInfoService;
import cn.com.poc.agent_application.constant.AgentApplicationDialoguesRecordConstants;
import cn.com.poc.agent_application.constant.AgentApplicationGCConfigConstants;
import cn.com.poc.agent_application.entity.BizAgentApplicationDialoguesRecordEntity;
import cn.com.poc.agent_application.entity.BizAgentApplicationGcConfigEntity;
import cn.com.poc.agent_application.entity.BizAgentApplicationPublishEntity;
import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.agent_application.query.MemberCollectQueryCondition;
import cn.com.poc.agent_application.query.MemberCollectQueryItem;
import cn.com.poc.agent_application.service.BizAgentApplicationDialoguesRecordService;
import cn.com.poc.agent_application.service.BizAgentApplicationGcConfigService;
import cn.com.poc.agent_application.service.BizAgentApplicationPublishService;
import cn.com.poc.agent_application.service.BizMemberAgentApplicationCollectService;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.constant.XLangConstant;
import cn.com.poc.common.service.RedisService;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.expose.aggregate.AgentApplicationService;
import cn.com.poc.knowledge.aggregate.KnowledgeService;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dialogue.Message;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dialogue.MultiContent;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dialogue.Tool;
import cn.com.poc.thirdparty.resource.demand.ai.constants.LLMRoleEnum;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelDemandResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelResponse;
import cn.com.poc.thirdparty.resource.demand.ai.function.LargeModelFunctionEnum;
import cn.com.poc.thirdparty.resource.demand.ai.function.value_memory.GetValueMemory;
import cn.com.poc.thirdparty.service.LLMService;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.data.model.PagingInfo;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.security.SecureRandom;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class AgentApplicationServiceImpl implements AgentApplicationService {

    final private Logger logger = LoggerFactory.getLogger(AgentApplicationService.class);

    final private String AGENT_APPLICATION_RECOMMEND_QUESTIONS = "AGENT_APPLICATION_RECOMMEND_QUESTIONS:";

    /**
     * 用户获取推荐问题的上一次记录
     */
    final private String MEMBER_RECOMMEND_QUESTIONS_LAST = AGENT_APPLICATION_RECOMMEND_QUESTIONS + "MEMBER_LAST:";


    @Resource
    private BizMemberAgentApplicationCollectService bizMemberAgentApplicationCollectService;

    @Resource
    private KnowledgeService knowledgeService;

    @Resource
    private BizAgentApplicationPublishService bizAgentApplicationPublishService;

    @Resource
    private BizAgentApplicationDialoguesRecordService bizAgentApplicationDialoguesRecordService;

    @Resource
    private AgentApplicationInfoService agentApplicationInfoService;

    @Resource
    private BizAgentApplicationGcConfigService bizAgentApplicationGcConfigService;

    @Resource
    private LLMService llmService;

    @Resource
    private RedisService redisService;

    @Override
    public void callAgentApplication(String agentId, String dialogsId, String input, HttpServletResponse httpServletResponse) {

        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new I18nMessageException("exception/user.not.login");
        }

        try {
            BizAgentApplicationPublishEntity infoEntity = bizAgentApplicationPublishService.getByAgentId(agentId);
            if (infoEntity == null) {
                logger.warn("can not find agent application , agent_id:{}", agentId);
                throw new I18nMessageException("exception/app.not.found");
            }

            if (StringUtils.isBlank(dialogsId)) {
                // 用于针对只有单Agent应用分享使用的场景，dialogsId为空
                dialogsId = agentId + "_" + userBaseEntity.getUserId();
            }

            //获取知识库配置
            List<Integer> kdIdList = knowledgeService.getKdIdsByKnowledgeInfoIds(infoEntity.getKnowledgeIds());


            // 构造对话参数
            List<Message> messages = buildMessages(dialogsId, agentId, userBaseEntity.getUserId(), input);

            //配置对话function
            List<Tool> tools = buildMemoryConfig(infoEntity, dialogsId);

            // 保存用户输入记录
            Long inputTimestamp = System.currentTimeMillis();
            BizAgentApplicationDialoguesRecordEntity inputRecord = new BizAgentApplicationDialoguesRecordEntity();
            inputRecord.setAgentId(agentId);
            inputRecord.setMemberId(userBaseEntity.getUserId());
            inputRecord.setContent(input);
            inputRecord.setDialogsId(dialogsId);
            inputRecord.setRole(AgentApplicationDialoguesRecordConstants.ROLE.USER);
            inputRecord.setTimestamp(inputTimestamp);
            bizAgentApplicationDialoguesRecordService.save(inputRecord);


            // 记录输出时间戳
            BizAgentApplicationDialoguesRecordEntity outputRecord = new BizAgentApplicationDialoguesRecordEntity();
            outputRecord.setRole(AgentApplicationDialoguesRecordConstants.ROLE.ASSISTANT);
            outputRecord.setAgentId(infoEntity.getAgentId());
            outputRecord.setDialogsId(dialogsId);
            outputRecord.setMemberId(userBaseEntity.getUserId());
            outputRecord.setTimestamp(System.currentTimeMillis());

            //对话
            String output = agentApplicationInfoService.callAgentApplication(agentId, dialogsId, infoEntity.getLargeModel(),
                    infoEntity.getUnitIds(), infoEntity.getAgentSystem(), kdIdList.toArray(new Integer[0]), infoEntity.getCommunicationTurn(),
                    infoEntity.getTopP(), infoEntity.getTemperature(), messages, tools, httpServletResponse);

            //保存对话记录
            outputRecord.setContent(output);
            bizAgentApplicationDialoguesRecordService.save(outputRecord);
        } catch (Exception e) {
            throw new I18nMessageException(e.getMessage());
        }
    }


    @Override
    public List<String> createContinueQuestions(String input) {
        BizAgentApplicationGcConfigEntity configEntity = bizAgentApplicationGcConfigService.getByConfigCode(AgentApplicationGCConfigConstants.AGENT_CONTINUE_QUESTIONS);
        if (null == configEntity) {
            throw new I18nMessageException("exception/create.[opening.statement].configuration.does.not.exist");
        }


        String configSystem = configEntity.getConfigSystem();
        configSystem = configSystem.replace("${input}", input);
        MultiContent systemMultiContent = new MultiContent();
        systemMultiContent.setText(configSystem);
        systemMultiContent.setType("text");
        List<MultiContent> multiContents = new ArrayList<>();
        multiContents.add(systemMultiContent);
        Message message = new Message();
        message.setContent(multiContents);
        message.setRole(LLMRoleEnum.USER.getRole());


        LargeModelResponse largeModelResponse = new LargeModelResponse();
        largeModelResponse.setModel(configEntity.getLargeModel());
        largeModelResponse.setMessages(new ArrayList<Message>() {{
            add(message);
        }}.toArray(new Message[1]));
        largeModelResponse.setTopP(configEntity.getTopP());
        largeModelResponse.setUser("POC-CONTINUE-QUESTIONS");
        LargeModelDemandResult largeModelDemandResult = llmService.chat(largeModelResponse);
        if (largeModelDemandResult == null || !"0".equals(largeModelDemandResult.getCode())) {
            logger.error("continue question error ,largeModelDemandResult:{} , largeModelResponse:{}", largeModelDemandResult != null ? largeModelDemandResult.toString() : StringUtils.EMPTY
                    , largeModelResponse);
            return null;
        }
        String res = largeModelDemandResult.getMessage();
        int start = res.lastIndexOf("[");
        int end = res.lastIndexOf("]");
        return JsonUtils.deSerialize(res.substring(start, end + 1), new TypeReference<List<String>>() {
        }.getType());
    }

    @Override
    public List<String> getRecommendQuestions(String xlang, Long memberId) {
        if (StringUtils.isBlank(xlang)) {
            xlang = XLangConstant.ZH_CN;
        }

        String redisKey = AGENT_APPLICATION_RECOMMEND_QUESTIONS + xlang;

        if (!redisService.hasKey(redisKey)) {
            synchronized (AgentApplicationInfoService.class) {
                if (!redisService.hasKey(redisKey)) {
                    createRecommendQuestion();
                }
            }
        }

        long size = redisService.lGetListSize(redisKey);
        if (size < 3) {
            redisService.del(redisKey);
            return null;
        }

        List<Object> lastRecomendIdSet = null;

        // 获取用户上一次的推荐话题ID，并在本次不重复获取该ID
        if (memberId != null) {
            String lastRecommendQuestionRedisKey = MEMBER_RECOMMEND_QUESTIONS_LAST + memberId;
            if (redisService.hasKey(lastRecommendQuestionRedisKey)) {
                lastRecomendIdSet = redisService.lGet(lastRecommendQuestionRedisKey, 0, -1);
            }
        }
        Set<Long> indexSet = new HashSet<>(3);
        SecureRandom secureRandom = new SecureRandom();

        do {
            long id = secureRandom.nextInt((int) size);
            if (CollectionUtils.isNotEmpty(lastRecomendIdSet) && lastRecomendIdSet.stream().anyMatch(v -> String.valueOf(v).equals(String.valueOf(id)))) {
                continue;
            }
            indexSet.add(id);
        } while (indexSet.size() < 3);

        List<String> result = new ArrayList<>(3);
        List<Object> recordIds = new ArrayList<>(3);
        for (Long index : indexSet) {
            Object str = redisService.lGetIndex(redisKey, index);
            result.add(str.toString());
            recordIds.add(index);
        }

        //更新记录
        if (memberId != null) {
            String lastRecommendQuestionRedisKey = MEMBER_RECOMMEND_QUESTIONS_LAST + memberId;
            redisService.del(lastRecommendQuestionRedisKey);
            redisService.lSet(lastRecommendQuestionRedisKey, recordIds, 10 * 60);
        }
        return result;
    }


    @Override
    public void createRecommendQuestion() {
        createCNQuestion();
        createENQuestion();
    }

    private void createCNQuestion() {
        Message message = new Message();
        message.setRole(LLMRoleEnum.USER.getRole());
        message.setContent("请你充当一个话题生成器，结合百度热榜数据，用json格式生成15条开放和引导式的推荐话题给我，我需要用于向AI提问问题，参考格式[\"话题内容\",\"话题N内容\"]，要求1.避免涉及敏感或争议性过强的话题，以确保问题的中立性和客观性。2.只要求生成话题，不需要旁白");

        Message[] messages = new Message[]{message};
        LargeModelResponse largeModelResponse = new LargeModelResponse();
        largeModelResponse.setModel("ERNIE-4.0-8K");
        largeModelResponse.setMessages(messages);
        LargeModelDemandResult largeModelDemandResult = llmService.chat(largeModelResponse);

        if (largeModelDemandResult == null || !"0".equals(largeModelDemandResult.getCode())) {
            throw new I18nMessageException("exception/failed.to.generate.recommendation.question");
        }
        String res = largeModelDemandResult.getMessage();
        int start = res.lastIndexOf("[");
        int end = res.lastIndexOf("]");
        List<Object> questions = JsonUtils.deSerialize(res.substring(start, end + 1), new TypeReference<List<Object>>() {
        }.getType());

        redisService.del(AGENT_APPLICATION_RECOMMEND_QUESTIONS + "zh-cn");
        redisService.lSet(AGENT_APPLICATION_RECOMMEND_QUESTIONS + "zh-cn", questions);

        List<Object> traditionalQuestion = questions.stream().map(q -> ZhConverterUtil.convertToTraditional(q.toString())).collect(Collectors.toList());
        redisService.del(AGENT_APPLICATION_RECOMMEND_QUESTIONS + "zh-tw");
        redisService.lSet(AGENT_APPLICATION_RECOMMEND_QUESTIONS + "zh-tw", traditionalQuestion);
    }

    private void createENQuestion() {
        Message message = new Message();
        message.setRole(LLMRoleEnum.USER.getRole());
        message.setContent("\n" +
                "Please act as a topic generator, combined with Baidu hot list data, generate 15 open and guided recommended topics for me in json format, I need to ask AI questions, refer to the format [\" Topic content \",\" Topic N content \"], requirement 1.2. Only topic generation is required, no narration is required,user english");

        Message[] messages = new Message[]{message};
        LargeModelResponse largeModelResponse = new LargeModelResponse();
        largeModelResponse.setModel("ERNIE-4.0-8K");
        largeModelResponse.setMessages(messages);
        LargeModelDemandResult largeModelDemandResult = llmService.chat(largeModelResponse);

        if (largeModelResponse == null || !"0".equals(largeModelDemandResult.getCode())) {
            throw new I18nMessageException("exception/failed.to.generate.recommendation.question");
        }
        String res = largeModelDemandResult.getMessage();
        int start = res.lastIndexOf("[");
        int end = res.lastIndexOf("]");
        List<Object> questions = JsonUtils.deSerialize(res.substring(start, end + 1), new TypeReference<List<Object>>() {
        }.getType());

        redisService.del(AGENT_APPLICATION_RECOMMEND_QUESTIONS + "en");
        redisService.lSet(AGENT_APPLICATION_RECOMMEND_QUESTIONS + "en", questions);
    }

    @Override
    public List<MemberCollectQueryItem> getCollectedApplications(Long memberId, PagingInfo pagingInfo) {
        MemberCollectQueryCondition condition = new MemberCollectQueryCondition();
        condition.setMemberId(memberId);
        condition.setIsCollect(CommonConstant.YOrN.Y);
        List<MemberCollectQueryItem> memberCollectQueryItems = bizMemberAgentApplicationCollectService.queryMemberCollect(condition, pagingInfo);
        return memberCollectQueryItems;
    }

    private List<Message> buildMessages(String dialogsId, String agentId, Long userId, String input) throws Exception {
        List<Message> messages = new ArrayList<>();
        BizAgentApplicationDialoguesRecordEntity recordEntity = new BizAgentApplicationDialoguesRecordEntity();
        recordEntity.setDialogsId(dialogsId);
        recordEntity.setMemberId(userId);
        recordEntity.setAgentId(agentId);
        List<BizAgentApplicationDialoguesRecordEntity> recordEntities = bizAgentApplicationDialoguesRecordService.findByExample(recordEntity, null);
        if (CollectionUtils.isNotEmpty(recordEntities)) {
            for (BizAgentApplicationDialoguesRecordEntity entity : recordEntities) {
                Message message = new Message();
                message.setContent(entity.getContent());
                message.setRole(entity.getRole());
                messages.add(message);
            }
        }

        //判断最后是否为User，若是则删除。
        if (CollectionUtils.isNotEmpty(messages)) {
            if (LLMRoleEnum.USER.getRole().equals(messages.get(messages.size() - 1).getRole())) {
                Long recordId = recordEntities.get(recordEntities.size() - 1).getId();
                bizAgentApplicationDialoguesRecordService.deletedById(recordId);
                messages.remove(messages.size() - 1);
            }
        }


        // 用户输入
        Message message = new Message();
        message.setContent(input);
        message.setRole(LLMRoleEnum.USER.getRole());
        messages.add(message);
        logger.info("--------- Build Messages dialogsId:{},agentId:{},messages:{}--------------", dialogsId, agentId, messages);
        return messages;
    }

    @Deprecated
    private void saveDialoguesRecord(String dialogsId, String input, BizAgentApplicationPublishEntity infoEntity, UserBaseEntity userBaseEntity, Long inputTimestamp, String output) throws Exception {
        // 回答时间戳
        Long outputTimestamp = System.currentTimeMillis();

        BizAgentApplicationDialoguesRecordEntity inputRecord = new BizAgentApplicationDialoguesRecordEntity();
        inputRecord.setAgentId(infoEntity.getAgentId());
        inputRecord.setMemberId(userBaseEntity.getUserId());
        inputRecord.setContent(input);
        inputRecord.setDialogsId(dialogsId);
        inputRecord.setRole(AgentApplicationDialoguesRecordConstants.ROLE.USER);
        inputRecord.setTimestamp(inputTimestamp);

        BizAgentApplicationDialoguesRecordEntity outputRecord = new BizAgentApplicationDialoguesRecordEntity();
        outputRecord.setRole(AgentApplicationDialoguesRecordConstants.ROLE.ASSISTANT);
        outputRecord.setAgentId(infoEntity.getAgentId());
        outputRecord.setDialogsId(dialogsId);
        outputRecord.setMemberId(userBaseEntity.getUserId());
        outputRecord.setContent(output);
        outputRecord.setTimestamp(outputTimestamp);

        bizAgentApplicationDialoguesRecordService.save(inputRecord);
        bizAgentApplicationDialoguesRecordService.save(outputRecord);
    }

    private List<Tool> buildMemoryConfig(BizAgentApplicationPublishEntity infoEntity, String identifier) {
        List<Tool> tools = new ArrayList<>();
        //开启对话变量
        if (CollectionUtils.isNotEmpty(infoEntity.getVariableStructure())) {
            String functionName = LargeModelFunctionEnum.set_value_memory.name();
            String llmConfig = LargeModelFunctionEnum.valueOf(functionName).getFunction().getVariableStructureLLMConfig(infoEntity.getVariableStructure()).get(0);
            Tool tool = JsonUtils.deSerialize(llmConfig, Tool.class);
            tools.add(tool);

            //初始化变量函数
            Map<Object, Object> map = GetValueMemory.get(identifier);
            if (MapUtils.isEmpty(map)) {
                List<Variable> variableStructure = infoEntity.getVariableStructure();
                for (Variable variable : variableStructure) {
                    String key = variable.getKey();
                    String variableDefault = variable.getVariableDefault();
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("contentName", key);
                    jsonObject.put("contentValue", variableDefault);
                    LargeModelFunctionEnum.valueOf(functionName).getFunction().doFunction(jsonObject.toJSONString(), identifier);
                }
            }
        }
        //开启长期记忆
        if (CommonConstant.YOrN.Y.equals(infoEntity.getIsLongMemory())) {
            String functionName = LargeModelFunctionEnum.set_long_memory.name();
            String llmConfig = LargeModelFunctionEnum.valueOf(functionName).getFunction().getLLMConfig().get(0);
            Tool tool = JsonUtils.deSerialize(llmConfig, Tool.class);
            tools.add(tool);
        }
        return tools;
    }
}
